/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowRecord;
import ru.bitel.common.Utils;

public class NetFlowArray
extends FlowArray<NetFlowRecord> {
    private static final Logger logger = LogManager.getLogger();

    public NetFlowArray(int size) {
        super(NetFlowArray.create(size));
    }

    private static final List<NetFlowRecord> create(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(String.valueOf(size));
        }
        ArrayList<NetFlowRecord> recordList = new ArrayList<NetFlowRecord>(size);
        for (int i = 0; i < size; ++i) {
            recordList.add(new NetFlowRecord());
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean parsePacket(ByteBuffer readBuffer, long millis) {
        int bufferPosition = readBuffer.position();
        try {
            int version = readBuffer.getShort(0) & 0xFFFF;
            int flowCount = readBuffer.getShort(2) & 0xFFFF;
            if (version == 1 || version == 5 || version == 7) {
                int flowLength;
                int flowsStart;
                switch (version) {
                    case 1: {
                        flowsStart = 17;
                        flowLength = 48;
                        break;
                    }
                    case 5: {
                        flowsStart = 24;
                        flowLength = 48;
                        break;
                    }
                    case 7: {
                        flowsStart = 24;
                        flowLength = 52;
                        break;
                    }
                    default: {
                        logger.error("Invalid netflow version: " + version);
                        boolean bl = false;
                        return bl;
                    }
                }
                if (flowsStart + flowLength * flowCount != readBuffer.limit()) {
                    logger.error("Corrupted packet length");
                    boolean bl = false;
                    return bl;
                }
                int offset = flowsStart;
                for (int j = 0; j < flowCount; ++j) {
                    NetFlowRecord rec = ((NetFlowRecord[])this.array)[j];
                    rec.fillData(readBuffer, offset);
                    rec.milliseconds = millis;
                    offset += flowLength;
                }
                this.size = flowCount;
            } else {
                logger.error("Invalid netflow version: " + version);
                this.size = 0;
            }
        }
        finally {
            readBuffer.position(bufferPosition);
        }
        return true;
    }

    public int next(ByteBuffer readBuffer) {
        int offset = readBuffer.position();
        int arrayOffset = 0;
        int limit = readBuffer.limit() - 1;
        this.size = 0;
        while (offset < limit) {
            long millis = readBuffer.getLong(offset);
            int version = readBuffer.getShort(offset += 8) & 0xFFFF;
            int flowCount = readBuffer.getShort(offset + 2) & 0xFFFF;
            if (version == 1 || version == 5 || version == 7) {
                int flowsStart;
                int flowLength = switch (version) {
                    case 1 -> {
                        flowsStart = 17;
                        yield 48;
                    }
                    case 5 -> {
                        flowsStart = 24;
                        yield 48;
                    }
                    default -> {
                        flowsStart = 24;
                        yield 52;
                    }
                };
                if ((offset += flowsStart) + flowLength * flowCount - 1 > limit) {
                    logger.error("Corrupted packet at offset: " + (offset - flowsStart) + " [flowLength=" + flowLength + ", flowCount=" + flowCount + ", limit=" + limit + "]");
                    offset = limit + 1;
                    break;
                }
                int size = arrayOffset + flowCount;
                for (int i = arrayOffset; i < size; ++i) {
                    NetFlowRecord rec = ((NetFlowRecord[])this.array)[i];
                    rec.fillData(readBuffer, offset);
                    rec.milliseconds = millis;
                    offset += flowLength;
                }
                arrayOffset += flowCount;
                continue;
            }
            this.size = arrayOffset;
            if (offset - 20 > 0) {
                logger.fatal("1111offset=" + offset);
                logger.fatal("1111limit=" + offset);
                logger.fatal((Object)readBuffer.position());
                byte[] b = new byte[72];
                readBuffer.mark();
                readBuffer.position(offset - 72);
                readBuffer.get(b);
                logger.fatal(Utils.bytesToHexString((byte[])b));
                Arrays.fill(b, (byte)-1);
                readBuffer.get(b);
                logger.fatal(Utils.bytesToHexString((byte[])b));
                readBuffer.reset();
                logger.fatal((Object)((NetFlowRecord[])this.array)[this.size - 1]);
                logger.fatal("");
                logger.fatal((Object)((NetFlowRecord[])this.array)[arrayOffset]);
                logger.fatal("");
                logger.fatal((Object)((NetFlowRecord[])this.array)[arrayOffset - 30]);
                logger.fatal((Object)((NetFlowRecord[])this.array)[arrayOffset - 5]);
                logger.fatal((Object)((NetFlowRecord[])this.array)[arrayOffset - 4]);
                logger.fatal((Object)((NetFlowRecord[])this.array)[arrayOffset - 3]);
                logger.fatal((Object)((NetFlowRecord[])this.array)[arrayOffset - 2]);
                logger.fatal((Object)((NetFlowRecord[])this.array)[arrayOffset - 1]);
            }
            throw new RuntimeException();
        }
        this.size = arrayOffset;
        return offset;
    }
}

