/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;

public class FileBackedLIFOQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
BlockingQueue<E> {
    protected final RandomAccessFile file;
    protected final ObjectOutputStream out;
    protected final long initialPosition;
    private final ReentrantLock lock = new ReentrantLock();
    protected final Condition notEmpty = this.lock.newCondition();
    protected final Condition notFull = this.lock.newCondition();
    private final int capacity;
    protected final ArrayDeque<E> queue;
    protected int count;
    protected final ArrayDeque<FilePointer> filePointers;

    public FileBackedLIFOQueue(File file, int capacity) throws BGException {
        this.capacity = capacity;
        this.queue = new ArrayDeque();
        this.count = 0;
        this.filePointers = new ArrayDeque();
        try {
            file.getParentFile().mkdirs();
            List<Object> oldList = Collections.emptyList();
            try {
                oldList = this.extractFromFile(file);
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
            file.delete();
            file.createNewFile();
            this.file = new RandomAccessFile(file, "rwd");
            this.out = new ObjectOutputStream(new FileOutputStream(this.file.getFD()));
            this.out.flush();
            this.initialPosition = this.file.getFilePointer();
            for (Object e : oldList) {
                this.insert(e, false);
            }
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    private List<E> extractFromFile(File file) throws ClassNotFoundException, IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (!file.exists()) {
            return result;
        }
        RandomAccessFile raFile = new RandomAccessFile(file, "r");
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(raFile.getFD()));
            try {
                Object o;
                while ((o = in.readObject()) != null) {
                    result.add(o);
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (IOException ex) {
            BGLogger.error(ex);
        }
        raFile.close();
        return result;
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void insert(E e, boolean signal) {
        try {
            this.filePointers.add(new FilePointer(this, this.file.getFilePointer()));
            this.out.writeObject(e);
            this.out.reset();
            this.out.flush();
            this.queue.offer(e);
            ++this.count;
            if (signal) {
                this.notEmpty.signal();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected E extract() {
        try {
            long position = this.filePointers.removeLast().value;
            this.file.seek(position);
            this.file.setLength(position);
            E e = this.queue.pollLast();
            --this.count;
            this.notFull.signal();
            return e;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count >= this.capacity) {
                boolean bl = false;
                return bl;
            }
            this.insert(e, true);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (this.count >= this.capacity) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException ie) {
                this.notFull.signal();
                throw ie;
            }
            this.insert(e, true);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.extract();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E x;
            if (this.count == 0) {
                E e = null;
                return e;
            }
            E e = x = this.extract();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            E x;
            try {
                while (this.count == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            E e = x = this.extract();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException();
    }

    class FilePointer {
        public long value;

        public FilePointer(FileBackedLIFOQueue this$0, long value) {
            this.value = value;
        }
    }
}

