/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.server.bean;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.Storage;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class LicenseRemoteDao {
    private Setup setup = Setup.getSetup();

    public List<LicenseData> list() throws Exception {
        ArrayList<LicenseData> list = new ArrayList<LicenseData>();
        String name = this.setup.get("license.contract.title", "");
        if (Utils.notBlankString(name)) {
            URLConnection connection = new URL(this.setup.get("license.server.url", "https://license.bitel.ru/license") + "?action=list").openConnection();
            ((HttpURLConnection)connection).addRequestProperty("name", name);
            ((HttpURLConnection)connection).addRequestProperty("password", this.setup.get("license.contract.password", ""));
            ((HttpURLConnection)connection).addRequestProperty("copyId", this.setup.get("license.product.id", ""));
            connection.setDoOutput(false);
            connection.setDoInput(true);
            connection.connect();
            if (((HttpURLConnection)connection).getResponseCode() == 200) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                String line = null;
                DateFormat dateFormat = TimeUtils.getDateFormat("dd.MM.yyyy HH:mm:ss");
                while ((line = bufferedReader.readLine()) != null) {
                    String[] tokens = line.split("\t");
                    list.add(LicenseData.builder().setId(Utils.parseInt(tokens[0])).setCreateDate(TimeUtils.parseDate(tokens[1], dateFormat)).setHash(tokens[2]).setCount(tokens.length > 3 ? Utils.parseInt(tokens[3]) : 0).setStorage(Storage.SERVER).build());
                }
                bufferedReader.close();
            } else {
                Object message = ((HttpURLConnection)connection).getResponseMessage();
                message = (String)message + " -> " + ((HttpURLConnection)connection).getHeaderField("ErrorMessage");
                throw new BGException((String)message);
            }
        }
        return list;
    }

    public String getLicenseText(int licenseId) throws Exception {
        StringBuffer licenseText = new StringBuffer();
        String name = this.setup.get("license.contract.title", "");
        if (Utils.notBlankString(name)) {
            URLConnection connection = new URL(this.setup.get("license.server.url", "https://license.bitel.ru/license") + "?action=licenseText").openConnection();
            ((HttpURLConnection)connection).addRequestProperty("name", name);
            ((HttpURLConnection)connection).addRequestProperty("password", this.setup.get("license.contract.password", ""));
            ((HttpURLConnection)connection).addRequestProperty("copyId", this.setup.get("license.product.id", ""));
            ((HttpURLConnection)connection).addRequestProperty("licenseId", String.valueOf(licenseId));
            connection.setDoOutput(false);
            connection.setDoInput(true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            char[] chars = new char[1000];
            int count = 0;
            while ((count = bufferedReader.read(chars)) > -1) {
                licenseText.append(String.valueOf(chars, 0, count));
            }
            bufferedReader.close();
        }
        return licenseText.toString();
    }
}

