/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.ParameterDao;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;

public class ActionGetHouseInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int houseid = this.getIntParameter("houseid", 0);
        int pid = this.getIntParameter("pid", -1);
        String flat = this.getParameter("flat", null);
        String room = this.getParameter("room", null);
        String pod = this.getParameter("pod", null);
        String floor = this.getParameter("floor", null);
        boolean isObject = this.getBooleanParameter("isObject", false);
        AddressStruct addressStruct = null;
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        try (HouseDao houseDao = new HouseDao(this.con);){
            House house = houseDao.get(houseid);
            if (house != null) {
                Element row = this.createElement(data, "row");
                row.setAttribute("f0", "" + houseid);
                row.setAttribute("f1", house.getPostIndex());
                row.setAttribute("f2", house.optCity().map(IdTitle::getTitle).orElse(""));
                row.setAttribute("f3", house.optArea().map(IdTitle::getTitle).orElse("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d"));
                row.setAttribute("f4", house.optQuarter().map(IdTitle::getTitle).orElse("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d"));
                row.setAttribute("f5", house.optStreet().map(IdTitle::getTitle).orElse(""));
                int s = house.getHouse();
                row.setAttribute("f6", (String)(s > 0 ? "" + s : "") + house.getFrac());
                row.setAttribute("f7", "" + house.getAmount());
                row.setAttribute("f9", house.getComment());
                row.setAttribute("f10", String.valueOf(house.getCity().getId()));
                row.setAttribute("f11", String.valueOf(house.getArea().getId()));
                row.setAttribute("f12", String.valueOf(house.getQuarter().getId()));
                row.setAttribute("f13", String.valueOf(house.getStreet().getId()));
                addressStruct = AddressStruct.builder().setIndex(house.getPostIndex()).setCountry((String)house.optCountry().map(IdTitle::getTitle).orElse(null)).setCity((String)house.optCity().map(IdTitle::getTitle).orElse(null)).setArea((String)house.optArea().map(IdTitle::getTitle).orElse(null)).setQuarter((String)house.optQuarter().map(IdTitle::getTitle).orElse(null)).setStreet(house.optStreet().map(IdTitle::getTitle).orElse("")).setHouse(String.valueOf(house.getHouse())).setFrac(house.getFrac()).setFlat(Utils.notEmptyString((String)flat) ? String.valueOf(flat) : null).setRoom(Utils.notEmptyString((String)room) ? String.valueOf(room) : null).setPod(Utils.notEmptyString((String)pod) ? String.valueOf(pod) : null).setFloor(Utils.notEmptyString((String)floor) ? String.valueOf(floor) : null).setComment(house.getComment()).build();
            }
        }
        String paramString = "address.house";
        List paramList = Utils.toList((String)this.setup.get(paramString, null));
        Map<String, String> paramMap = new ParameterDao(this.con).getAddressParams("address_house", houseid);
        Element extraParams = this.createElement(this.rootNode, "extraParams");
        for (String str : paramList) {
            if (paramMap.get(str) == null) continue;
            Element param = this.createElement(extraParams, "param");
            param.setAttribute("param_id", str);
            param.setAttribute("param_title", this.setup.get(paramString + "." + str + ".title", null));
            param.setAttribute("param_value", paramMap.get(str));
        }
        if (pid > 0) {
            this.getFormatAddressTable(addressStruct != null ? addressStruct : new AddressStruct(), pid, null, isObject);
        }
    }
}

