/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.script;

import bitel.billing.module.common.BSHEditor;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.bgbilling.kernel.script.common.service.ScriptService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class BackupHistoryBGPanel
extends BGPanel {
    protected int currentId;
    private int scriptType;
    protected CardLayout cardLayout = new CardLayout();
    private BGPanel parentPanel;
    private CardLayout parentCardLayout;
    private ViewBackupPanel viewer;
    private BGUTable table;
    private Directory<UserInfo> userDirectory;
    private BGTableModel<ScriptBackup> model = new BGTableModel<ScriptBackup>("script_backup"){

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0412\u0440\u0435\u043c\u044f", 150, 150, 220, "time", true);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 150, 150, 220, "userName", true);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u0438", 300, 300, 400, "title", false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 140, 140, -1, "comment", false);
        }

        @Override
        public Object getValue(ScriptBackup val, int column) throws Exception {
            switch (column) {
                case 1: {
                    return TimeUtils.format(val.getTimeRevision(), "dd.MM.yyyy HH:mm:ss");
                }
                case 2: {
                    UserInfo user = BackupHistoryBGPanel.this.userDirectory.get(val.getUserId());
                    return user == null ? null : user.getName();
                }
            }
            return super.getValue(val, column);
        }
    };

    public BackupHistoryBGPanel(int type, CardLayout parentCardLayout, BGPanel parentPanel) {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.scriptType = type;
        this.parentCardLayout = parentCardLayout;
        this.parentPanel = parentPanel;
    }

    protected void jbInit() {
        this.table = new BGUTable(this.model);
        JButton closeButton = new JButton("\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440");
        closeButton.addActionListener(e -> this.parentCardLayout.first(this.parentPanel));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setName("table");
        mainPanel.add((Component)BGSwingUtilites.wrapBorder(new JScrollPane(this.table), " \u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 "), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)closeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(this.cardLayout);
        this.add((Component)mainPanel, "table");
        this.viewer = new ViewBackupPanel();
        this.add((Component)this.viewer, "viewer");
        this.cardLayout.show(this, "table");
        BGSwingUtilites.handleLDMouseClicked(this.table, e -> this.tableMouseClicked((MouseEvent)e));
    }

    private void tableMouseClicked(MouseEvent event) {
        int selectedBackupId = this.model.getSelectedRow().getId();
        if (selectedBackupId > 0) {
            this.viewer.currentBackupId = selectedBackupId;
            this.viewer.trySetData();
            this.cardLayout.show(this, "viewer");
        }
    }

    @Override
    public void setData() throws Exception {
        this.userDirectory = this.getContext().getDirectory(UserInfo.class, 0);
        this.model.setData(this.getContext().getPort(ScriptService.class).listBackup(this.currentId, this.scriptType));
    }

    @Override
    public void deleteItem() {
        if (this.viewer.isShowing()) {
            this.viewer.deleteItem();
            return;
        }
        ScriptBackup selectedBackup = this.model.getSelectedRow();
        if (selectedBackup == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0431\u044d\u043a\u0430\u043f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getContext().getPort(ScriptService.class).deleteBackup(selectedBackup.getId());
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    class ViewBackupPanel
    extends BGPanel {
        protected int currentBackupId;
        private BGTextField title;
        private BSHEditor script;

        public ViewBackupPanel() {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        private void jbInit() {
            this.title = new BGTextField();
            this.script = new BSHEditor();
            this.setLayout(new GridBagLayout());
            JButton closeButton = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
            closeButton.addActionListener(e -> BackupHistoryBGPanel.this.cardLayout.first(BackupHistoryBGPanel.this));
            this.add((Component)BGSwingUtilites.wrapBorder(this.title, " \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)BGSwingUtilites.wrapBorder(this.script, " \u041a\u043e\u0434 "), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)closeButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        @Override
        public void setData() throws Exception {
            ScriptBackup backup = this.getContext().getPort(ScriptService.class).getBackup(this.currentBackupId);
            this.title.setText(backup.getTitle());
            this.script.setText(backup.getScript());
        }
    }
}

