/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionExpressionData;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.common.Utils;

public class ServiceAction
extends ModuleAction {
    private static final JexlEngine JEXL = new JexlEngine();
    final String name;
    final Set<String> operations;
    private String expression;

    public ServiceAction(ActionExpressionData actionExpressionData) {
        super(actionExpressionData.getServiceId() + "_" + actionExpressionData.getId(), actionExpressionData.getTitle());
        this.name = actionExpressionData.getServiceName();
        this.operations = new HashSet<String>(Arrays.asList(actionExpressionData.getServiceOperation()));
        this.expression = actionExpressionData.getServiceExpression();
    }

    public ServiceAction(Element service) {
        super(service);
        this.name = service.getAttribute("name");
        this.expression = service.getAttribute("expression");
        String operation = service.getAttribute("operation");
        if (Utils.notBlankString(operation)) {
            this.operations = new HashSet<String>(Arrays.asList(operation.split("\\s*\\|\\s*")));
            this.operations.remove("");
        } else {
            this.operations = null;
        }
    }

    public boolean isCoincide(String operation, Map<String, Object> args) {
        if (this.operations != null && !this.operations.contains(operation)) {
            return false;
        }
        if (Utils.notBlankString(this.expression)) {
            boolean bl;
            Object result = JEXL.createExpression(this.expression).evaluate((JexlContext)new MapContext(args));
            if (result instanceof Boolean) {
                Boolean bool = (Boolean)result;
                bl = bool;
            } else {
                bl = false;
            }
            return bl;
        }
        return true;
    }

    static {
        JEXL.setCache(100);
    }
}

