/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.ModTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class IconCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
    protected Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
    protected Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
    protected Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
    protected Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
    protected boolean m_selected;

    public IconCellRenderer() {
        this.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof ModTreeNode) {
            ModTreeNode node = (ModTreeNode)value;
            this.setIcon(ClientUtils.getIcon(node.getIcon()));
            this.setText(node.getText());
        }
        this.setFont(tree.getFont());
        this.setForeground(sel ? this.m_textSelectionColor : this.m_textNonSelectionColor);
        this.setBackground(sel ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
        this.m_selected = sel;
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        Color bColor = this.getBackground();
        Icon icon = this.getIcon();
        g.setColor(bColor);
        int offset = 0;
        if (icon != null && this.getText() != null) {
            offset = icon.getIconWidth() + this.getIconTextGap();
        }
        g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        if (this.m_selected) {
            g.setColor(this.m_borderSelectionColor);
            g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        }
        super.paintComponent(g);
    }
}

