/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.web.common.service.BGWebService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternMasterPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.PatternData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBoxRefresh;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.function.ThrowingSupplier;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;

public class PatternGeneralPanel
extends PatternBaseTabPanel {
    private static final String TITLE_PATTERN_ID = "title_pattern_id";
    private PatternData patternData;
    private List<KeyValue> faceValues = Arrays.asList(new KeyValue("0", "\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435"), new KeyValue("1", "\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0435"));
    private List<KeyValue> modeValues = Arrays.asList(new KeyValue("0", "\u041a\u0440\u0435\u0434\u0438\u0442"), new KeyValue("1", "\u0414\u0435\u0431\u0435\u0442"));
    private List<KeyValue> limitModeLKValues = Arrays.asList(new KeyValue("on", "\u0420\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e"), new KeyValue("off", "\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e"));
    private List<KeyValue> patternModeValues = Arrays.asList(new KeyValue("basic", "\u0411\u0430\u0437\u043e\u0432\u044b\u0439"), new KeyValue("master", "\u041c\u0430\u0441\u0442\u0435\u0440"));
    private Async<List<KeyValue>> statusValues;
    private Async<List<KeyValue>> domainValues;
    private Async<List<KeyValue>> webMenuValues;
    private Async<List<KeyValue>> parameterValues;
    private Async<List<KeyValue>> commentPatternValues;
    private Async<List<KeyValue>> patternGeneratorValues;
    private Async<List<IdTitle>> contractParameterValues;
    private ThrowingSupplier<List<KeyValue>> domainSupplier;
    private ThrowingSupplier<List<KeyValue>> statusSupplier;
    private ThrowingSupplier<List<KeyValue>> webMenuSupplier;
    private ThrowingSupplier<List<KeyValue>> parameterSupplier;
    private ThrowingSupplier<List<KeyValue>> commentPatternSupplier;
    private ThrowingSupplier<List<KeyValue>> patternGeneratorSupplier;
    private Param paramPatternName = new Param(this, "\u0428\u0430\u0431\u043b\u043e\u043d \u0438\u043c\u0435\u043d\u0438", "0");
    private Param paramLifetime = new Param(this, "\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 (\u0434\u043d\u0438, 0 - \u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e)", "0");
    private Param paramLimit = new Param(this, "\u041b\u0438\u043c\u0438\u0442", "0");
    private Param paramLimitModeLK = new Param(this, "\u0420\u0435\u0436\u0438\u043c \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u043e\u043c \u0432 \u041b\u041a", "off");
    private Param paramFace = new Param(this, "\u041b\u0438\u0446\u043e", "0");
    private Param paramMode = new Param(this, "\u0420\u0435\u0436\u0438\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "0");
    private Param paramStatus = new Param(this, "\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "0");
    private Param paramDomain = new Param(this, "\u0414\u043e\u043c\u0435\u043d", "0");
    private Param paramCommentPattern = new Param(this, "\u0428\u0430\u0431\u043b\u043e\u043d \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "0");
    private Param paramParameter = new Param(this, "\u0413\u0440\u0443\u043f\u043f\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "0");
    private Param paramWebMenu = new Param(this, "Web-\u043c\u0435\u043d\u044e", "-1");
    private Param paramPatternMode = new Param(this, "\u0420\u0435\u0436\u0438\u043c \u0448\u0430\u0431\u043b\u043e\u043d\u0430", "basic");
    private List<Param> params = Arrays.asList(this.paramPatternName, this.paramLifetime, this.paramLimit, this.paramLimitModeLK, this.paramFace, this.paramMode, this.paramStatus, this.paramCommentPattern, this.paramParameter, this.paramDomain, this.paramWebMenu, this.paramPatternMode);
    private PatternMasterPanel patternMasterPanel = new PatternMasterPanel();
    private GeneralParamTableModel paramTableModel = new GeneralParamTableModel();

    public PatternGeneralPanel(Document moduleDoc) {
        this.statusSupplier = () -> ((ContractStatusService)this.getKernelContext().getWebService(ContractStatusService.class)).getStatusList(false).stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getTitle())).toList();
        this.webMenuSupplier = () -> {
            ArrayList<KeyValue> values = new ArrayList<KeyValue>();
            values.add(new KeyValue("-1", "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"));
            ((BGWebService)this.getKernelContext().getWebService(BGWebService.class)).webMenuList(false).forEach(a -> values.add(new KeyValue(String.valueOf(a.getId()), a.getGuiTitle())));
            return values;
        };
        this.parameterSupplier = () -> ((ContractPatternService)this.getKernelContext().getWebService(ContractPatternService.class)).contractParameterGroupList();
        this.commentPatternSupplier = () -> ((ContractPatternService)this.getKernelContext().getWebService(ContractPatternService.class)).contractCommentPatternList();
        this.domainSupplier = () -> {
            List domains = this.getContext().getDirectory(Domain.class, 0).list();
            ArrayList<KeyValue> domainsWithoutParents = new ArrayList<KeyValue>(domains.size() + 1);
            KeyValue separator = new KeyValue("0", KeyValue.NO_SELECT.getValue());
            domainsWithoutParents.add(separator);
            domains.forEach(a -> {
                KeyValue keyValue = new KeyValue(String.valueOf(a.getId()), null);
                this.buildDomainPath(domains, a.getId(), keyValue);
                domainsWithoutParents.add(keyValue);
            });
            return domainsWithoutParents;
        };
        this.patternGeneratorSupplier = () -> {
            ArrayList<KeyValue> values = new ArrayList<KeyValue>();
            values.add(new KeyValue("0", ""));
            values.addAll(((ContractPatternService)this.getContext().getWebService(ContractPatternService.class, 0)).patternGeneratorTitles().stream().map(a -> new KeyValue(String.valueOf(a.getId()), a.getTitle())).toList());
            return values;
        };
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        font = new FontUIResource(new Font(font.getName(), font.getStyle(), font.getSize() + 2));
        int fontHeight = this.getFontMetrics(font).getHeight() + 3;
        BGUTable table = new BGUTable((TableModel)((Object)this.paramTableModel));
        table.setFont((Font)font);
        table.setRowHeight(fontHeight);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    PatternGeneralPanel.this.openEditor();
                }
            }
        });
        this.paramTableModel.setData(this.params);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.setDimension((JComponent)((Object)this.patternMasterPanel), (int)300, (int)400), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void openEditor() {
        Param param = (Param)this.paramTableModel.getSelectedRow();
        if (param == this.paramLimitModeLK) {
            new EditorWithTwoButton(this, param.name, param, this.limitModeLKValues.get(0), this.limitModeLKValues.get(1)).open();
        } else if (param == this.paramFace) {
            new EditorWithTwoButton(this, param.name, param, this.faceValues.get(0), this.faceValues.get(1)).open();
        } else if (param == this.paramMode) {
            new EditorWithTwoButton(this, param.name, param, this.modeValues.get(0), this.modeValues.get(1)).open();
        } else if (param == this.paramPatternMode) {
            new EditorWithTwoButton(this, param.name, param, this.patternModeValues.get(0), this.patternModeValues.get(1)).open();
        } else if (param == this.paramPatternName) {
            new EditorList(this, param.name, param, this.patternGeneratorSupplier).open();
        } else if (param == this.paramLifetime) {
            new EditorText(this, param.name, param, "^\\d+$").open();
        } else if (param == this.paramLimit) {
            new EditorText(this, param.name, param, "^-?\\d+$").open();
        } else if (param == this.paramStatus) {
            new EditorList(this, param.name, param, this.statusSupplier).open();
        } else if (param == this.paramDomain) {
            new EditorList(this, param.name, param, this.domainSupplier).open();
        } else if (param == this.paramCommentPattern) {
            new EditorList(this, param.name, param, this.commentPatternSupplier).open();
        } else if (param == this.paramParameter) {
            new EditorList(this, param.name, param, this.parameterSupplier).open();
        } else if (param == this.paramWebMenu) {
            new EditorList(this, param.name, param, this.webMenuSupplier).open();
        }
        this.setData(this.patternData);
    }

    @Override
    public void setData(PatternData patternData) {
        this.patternData = patternData;
        this.statusValues = Async.of(this.statusSupplier);
        this.domainValues = Async.of(this.domainSupplier);
        this.webMenuValues = Async.of(this.webMenuSupplier);
        this.parameterValues = Async.of(this.parameterSupplier);
        this.commentPatternValues = Async.of(this.commentPatternSupplier);
        this.patternGeneratorValues = Async.of(this.patternGeneratorSupplier);
        this.contractParameterValues = Async.of(() -> {
            ArrayList values = new ArrayList();
            ((ContractParameterService)this.getContext().getWebService(ContractParameterService.class, 0)).contractParameterGroupAttrList().stream().filter(a -> a.getType() > 0).forEach(a -> values.add(new IdTitle(a.getId(), a.getTitle() + " [" + a.getTypeName() + "]")));
            return values;
        });
        this.patternMasterPanel.setData((List)this.contractParameterValues.get());
    }

    private void buildDomainPath(List<Domain> domains, int id, KeyValue value) {
        Domain domain = domains.stream().filter(a -> a.getId() == id).findFirst().orElse(null);
        if (domain != null) {
            value.setValue(domain.getGuiTitle() + (String)(value.getValue() == null ? "" : " => " + value.getValue()));
            this.buildDomainPath(domains, domain.getParentId(), value);
        }
    }

    @Override
    public void setPatternData(ContractPattern contractPattern) {
        this.paramPatternName.setValue(contractPattern.getNamePatternId());
        this.paramLifetime.setValue(contractPattern.getDaysToLive());
        this.paramLimit.setValue(new DecimalFormat("####.##").format(contractPattern.getClosesumma()));
        this.paramLimitModeLK.setValue(contractPattern.getLimitMode());
        this.paramFace.setValue(contractPattern.getFc());
        this.paramMode.setValue(contractPattern.getMode());
        this.paramStatus.setValue(contractPattern.getStatus());
        this.paramDomain.setValue(contractPattern.getDomainId());
        this.paramCommentPattern.setValue(contractPattern.getPatternId());
        this.paramParameter.setValue(contractPattern.getParamsGroupId());
        this.paramWebMenu.setValue(contractPattern.getWebMenuId());
        this.paramPatternMode.setValue(contractPattern.getPatternMode());
        this.paramTableModel.fireTableDataChanged();
        this.patternMasterPanel.setValue(contractPattern);
    }

    @Override
    public boolean setRequestData(Request request) {
        request.setAttribute("dtl", this.paramLifetime.getValue());
        request.setAttribute("name_pattern_id", this.paramPatternName.getValue());
        request.setAttribute("domainId", this.paramDomain.getValue());
        request.setAttribute("limit", this.paramLimit.getValue());
        request.setAttribute("status", this.paramStatus.getValue());
        request.setAttribute("limitMode", this.paramLimitModeLK.getValue());
        request.setAttribute("mode", this.paramMode.getValue());
        request.setAttribute("face", this.paramFace.getValue());
        request.setAttribute("patternMode", this.paramPatternMode.getValue());
        request.setAttribute("web_menu_id", this.paramWebMenu.getValue());
        request.setAttribute("pattern_mode", this.paramPatternMode.getValue());
        request.setAttribute("masterHandlerClass", this.patternMasterPanel.getHandlerClass());
        request.setAttribute("masterRequiredParameterIds", Utils.toString(this.patternMasterPanel.getMasterRequiredParameterIds()));
        request.setAttribute("masterOptionalParameterIds", Utils.toString(this.patternMasterPanel.getMasterOptionalParameterIds()));
        request.setAttribute("masterTariffMode", this.patternMasterPanel.getMasterTariffMode());
        int value = Utils.parseInt((String)this.paramCommentPattern.getValue());
        if (value < -1) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0448\u0430\u0431\u043b\u043e\u043d \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f!");
            return false;
        }
        request.setAttribute(TITLE_PATTERN_ID, value);
        value = Utils.parseInt((String)this.paramParameter.getValue());
        if (value < -1) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0433\u0440\u0443\u043f\u043f\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!");
            return false;
        }
        request.setAttribute("parameter", value);
        return true;
    }

    @Override
    public void resetData() {
        this.paramPatternName.setValue("");
        this.paramLifetime.setValue("0");
        this.paramLimit.setValue("0");
        this.paramLimitModeLK.setValue("off");
        this.paramFace.setValue("0");
        this.paramMode.setValue("0");
        this.paramStatus.setValue("0");
        this.paramDomain.setValue("0");
        this.paramCommentPattern.setValue("0");
        this.paramParameter.setValue("0");
        this.paramWebMenu.setValue("-1");
        this.paramPatternMode.setValue("basic");
    }

    public class Param {
        private final String name;
        private String value;

        public Param(PatternGeneralPanel this$0, String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setValue(int value) {
            this.value = String.valueOf(value);
        }
    }

    class GeneralParamTableModel
    extends BGTableModel<Param> {
        public GeneralParamTableModel() {
            super(GeneralParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 300, 400, 500, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 200, 300, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(Param val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("value".equals(identifier)) {
                if (val == PatternGeneralPanel.this.paramFace) {
                    return this.getVal(val, PatternGeneralPanel.this.faceValues);
                }
                if (val == PatternGeneralPanel.this.paramMode) {
                    return this.getVal(val, PatternGeneralPanel.this.modeValues);
                }
                if (val == PatternGeneralPanel.this.paramLimitModeLK) {
                    return this.getVal(val, PatternGeneralPanel.this.limitModeLKValues);
                }
                if (val == PatternGeneralPanel.this.paramPatternMode) {
                    return this.getVal(val, PatternGeneralPanel.this.patternModeValues);
                }
                if (val == PatternGeneralPanel.this.paramStatus) {
                    return this.getVal(val, (List)PatternGeneralPanel.this.statusValues.get());
                }
                if (val == PatternGeneralPanel.this.paramCommentPattern) {
                    return this.getVal(val, (List)PatternGeneralPanel.this.commentPatternValues.get());
                }
                if (val == PatternGeneralPanel.this.paramParameter) {
                    return this.getVal(val, (List)PatternGeneralPanel.this.parameterValues.get());
                }
                if (val == PatternGeneralPanel.this.paramWebMenu) {
                    return this.getVal(val, (List)PatternGeneralPanel.this.webMenuValues.get());
                }
                if (val == PatternGeneralPanel.this.paramDomain) {
                    return this.getVal(val, PatternGeneralPanel.this.domainValues != null ? (List)PatternGeneralPanel.this.domainValues.get() : Collections.emptyList());
                }
                if (val == PatternGeneralPanel.this.paramPatternName) {
                    return this.getVal(val, PatternGeneralPanel.this.patternGeneratorValues != null ? (List)PatternGeneralPanel.this.patternGeneratorValues.get() : Collections.emptyList());
                }
                return super.getValue((Object)val, column);
            }
            return super.getValue((Object)val, column);
        }

        private String getVal(Param param, List<KeyValue> values) {
            return values.stream().filter(a -> a.getKey().equals(param.getValue())).findFirst().orElse(new KeyValue()).getGuiTitle();
        }
    }

    class EditorWithTwoButton
    extends BGEditorDialog<Param> {
        private KeyValue value1;
        private KeyValue value2;
        private ButtonGroup buttonGroup = new ButtonGroup();
        private JToggleButton button1 = new JToggleButton();
        private JToggleButton button2 = new JToggleButton();

        public EditorWithTwoButton(PatternGeneralPanel this$0, String title, Param data, KeyValue value1, KeyValue value2) {
            super(title, (Object)data);
            this.value1 = value1;
            this.value2 = value2;
        }

        public void doDialogPanel() {
            Dimension dimension = new Dimension(175, 32);
            this.button1.setText(this.value1.getValue());
            this.button1.setActionCommand(this.value1.getKey());
            this.button1.setMinimumSize(dimension);
            this.button1.setPreferredSize(dimension);
            this.buttonGroup.add(this.button1);
            this.button2.setText(this.value2.getValue());
            this.button2.setActionCommand(this.value2.getKey());
            this.button2.setMinimumSize(dimension);
            this.button2.setPreferredSize(dimension);
            this.buttonGroup.add(this.button2);
            this.panel.add((Component)this.button1, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
            this.panel.add((Component)this.button2, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
            Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                abstractButton.setSelected(abstractButton.getActionCommand().equals(((Param)this.data).getValue()));
            }
        }

        public boolean doApply() throws Exception {
            ((Param)this.data).setValue(this.buttonGroup.getSelection().getActionCommand());
            return true;
        }
    }

    class EditorList
    extends BGEditorDialog<Param> {
        private ThrowingSupplier<List<KeyValue>> supplier = null;
        private BGUComboBoxRefresh<KeyValue> list = new BGUComboBoxRefresh();

        public EditorList(PatternGeneralPanel this$0, String title, Param data, ThrowingSupplier<List<KeyValue>> supplier) {
            super(title, (Object)data);
            this.supplier = supplier;
        }

        public void doDialogPanel() {
            Dimension dimension = new Dimension(500, 32);
            this.panel.add((Component)this.list, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
            this.list.setMinimumSize(dimension);
            this.list.setPreferredSize(dimension);
            this.list.setSupplier(this.supplier);
            List values = this.list.refresh();
            this.list.setData(values);
            this.list.setSelectedItem((Object)values.stream().filter(a -> a.getKey().equals(((Param)this.data).getValue())).findFirst().orElse((KeyValue)values.get(0)));
        }

        public boolean doApply() throws Exception {
            ((Param)this.data).setValue(((KeyValue)this.list.getSelectedItem()).getKey());
            return true;
        }
    }

    class EditorText
    extends BGEditorDialog<Param> {
        private String regexp = ".*";
        private BGTextField value = new BGTextField(40);

        public EditorText(PatternGeneralPanel this$0, String title, Param data, String regexp) {
            super(title, (Object)data);
            this.regexp = regexp;
        }

        public void doDialogPanel() {
            this.value.setHorizontalAlignment(0);
            this.panel.add((Component)this.value, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.value.setText(((Param)this.data).getValue());
        }

        public boolean doApply() throws Exception {
            if (!this.value.getText().matches(this.regexp)) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
                return false;
            }
            ((Param)this.data).setValue(this.value.getText());
            return true;
        }
    }
}

