/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.oss.kernel.directories.address.common.bean.House;

public class ParameterIds {
    private Map<String, Integer> ids = new HashMap<String, Integer>();

    public int getCountryId() {
        return this.ids.get(TableName.COUNTRY.getTableName());
    }

    public int getRegionId() {
        return this.ids.get(TableName.REGION.getTableName());
    }

    public int getCityId() {
        return this.ids.get(TableName.CITY.getTableName());
    }

    public int getStreetId() {
        return this.ids.get(TableName.STREET.getTableName());
    }

    public int getAreaId() {
        return this.ids.get(TableName.AREA.getTableName());
    }

    public int getQuarterId() {
        return this.ids.get(TableName.QUARTER.getTableName());
    }

    public int getHouseId() {
        return this.ids.get(TableName.HOUSE.getTableName());
    }

    public int getCount() {
        return this.ids.size();
    }

    public Map<String, Integer> getIds() {
        return this.ids;
    }

    public void setCountryId(int countryId) {
        if (countryId > 0) {
            this.ids.put(TableName.COUNTRY.getTableName(), countryId);
        }
    }

    public void setRegionId(int regionId) {
        if (regionId > 0) {
            this.ids.put(TableName.REGION.getTableName(), regionId);
        }
    }

    public void setCityId(int cityId) {
        if (cityId > 0) {
            this.ids.put(TableName.CITY.getTableName(), cityId);
        }
    }

    public void setStreetId(int streetId) {
        if (streetId > 0) {
            this.ids.put(TableName.STREET.getTableName(), streetId);
        }
    }

    public void setAreaId(int areaId) {
        if (areaId > 0) {
            this.ids.put(TableName.AREA.getTableName(), areaId);
        }
    }

    public void setQuarterId(int quarterId) {
        if (quarterId > 0) {
            this.ids.put(TableName.QUARTER.getTableName(), quarterId);
        }
    }

    public void setHouseId(int houseId) {
        if (houseId > 0) {
            this.ids.put(TableName.HOUSE.getTableName(), houseId);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(House house) {
        return new Builder(house);
    }

    static enum TableName {
        COUNTRY("address_country"),
        REGION("address_region"),
        CITY("address_city"),
        STREET("address_street"),
        AREA("address_area"),
        QUARTER("address_quarter"),
        HOUSE("address_house");

        private String tableName;

        private TableName(String tableName) {
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class Builder {
        private ParameterIds ids = new ParameterIds();

        private Builder() {
        }

        private Builder(House house) {
            this.ids.setCountryId(house.getCountry().getId());
            this.ids.setCityId(house.getCity().getId());
            this.ids.setStreetId(house.getStreet().getId());
            this.ids.setAreaId(house.getArea().getId());
            this.ids.setQuarterId(house.getQuarter().getId());
            this.ids.setHouseId(house.getId());
        }

        public Builder setCountryId(int countryId) {
            this.ids.setCountryId(countryId);
            return this;
        }

        public Builder setRegionId(int regionId) {
            this.ids.setRegionId(regionId);
            return this;
        }

        public Builder setCityId(int cityId) {
            this.ids.setCityId(cityId);
            return this;
        }

        public Builder setStreetId(int streetId) {
            this.ids.setStreetId(streetId);
            return this;
        }

        public Builder setAreaId(int areaId) {
            this.ids.setAreaId(areaId);
            return this;
        }

        public Builder setQuarterId(int quarterId) {
            this.ids.setQuarterId(quarterId);
            return this;
        }

        public Builder setHouseId(int houseId) {
            this.ids.setHouseId(houseId);
            return this;
        }

        public ParameterIds build() {
            try {
                ParameterIds parameterIds = this.ids;
                return parameterIds;
            }
            finally {
                this.ids = null;
            }
        }
    }
}

