/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class TableWebLog
extends BGTableInfoBase {
    public TableWebLog() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextCenter("\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f", "dtime").setWidth(150), BGUTableColumn.buildColumnTextCenter("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", "contractTitle").setWidth(150), BGUTableColumn.buildColumnTextCenter("IP \u0430\u0434\u0440\u0435\u0441", "ip").setWidth(300), BGUTableColumn.buildColumnTextCenter("\u041c\u043e\u0434\u0443\u043b\u044c", "module").setWidth(150), BGUTableColumn.buildColumnTextLeft("\u0417\u0430\u043f\u0440\u043e\u0441", "query").setWidth(-1)};
    }

    @Override
    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        Page page = tableParams.getPage();
        Period period = tableParams.getPeriod();
        String cidList = tableParams.get("contracts");
        String queryFilter = "%" + tableParams.get("query_filter", "") + "%";
        StringBuffer filterString = new StringBuffer().append(" WHERE dtime>='").append(TimeUtils.formatSQLDate((Date)period.getDateFrom())).append("'").append(" AND dtime<'").append(TimeUtils.formatSQLDate((Calendar)TimeUtils.getNextDay((Calendar)TimeUtils.convertDateToCalendar((Date)period.getDateTo())))).append("'").append(" AND query LIKE ?");
        if (Utils.notEmptyString((String)cidList)) {
            filterString.append(" AND cid IN ( ").append(cidList).append(" ) ");
        }
        Object tableName = "web_query_log_" + TimeUtils.format((Date)period.getDateFrom(), (String)"MMyyyy");
        String tableName2 = ServerUtils.getMonthTableName("web_query_log", period.getDateFrom());
        Connection con = this.getContext().getConnection();
        StringBuffer query = null;
        if (ServerUtils.tableExists(con, (String)tableName)) {
            query = new StringBuffer().append("SELECT log.dtime, contract.title, log.ip, module.title, log.query ").append("FROM ").append((String)tableName).append(" AS log ").append("LEFT JOIN contract ON log.cid=contract.id ").append("LEFT JOIN module ON log.mid=module.id ").append(filterString).append(" ORDER BY dtime").append(Page.toSqlLimit((Page)page));
        } else if (ServerUtils.tableExists(con, tableName2)) {
            query = new StringBuffer().append("SELECT dtime, c_title, ip, m_title, query FROM ").append(tableName2).append(" ").append(filterString).append(" ORDER BY dtime ").append(Page.toSqlLimit((Page)page));
            tableName = tableName2;
        }
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        if (query != null) {
            try (PreparedStatement ps = con.prepareStatement(query.toString());){
                ps.setString(1, queryFilter);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        BGUTableRowData rowData = new BGUTableRowData().addValue("contractTitle", Optional.ofNullable(rs.getString(2)).orElse("")).addValue("dtime", TimeUtils.formatFullDate((Date)rs.getTimestamp(1))).addValue("ip", rs.getString(3)).addValue("module", Optional.ofNullable(rs.getString(4)).orElse("???")).addValue("query", Optional.ofNullable(rs.getString(5)).orElse("").replaceAll("\n", "; "));
                        rowDatas.add(rowData);
                    }
                }
            }
            int records = 0;
            query = new StringBuffer().append("SELECT COUNT(*) FROM ").append((String)tableName).append(filterString);
            try (PreparedStatement ps = con.prepareStatement(query.toString());){
                ps.setString(1, queryFilter);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        records = rs.getInt(1);
                    }
                }
            }
            page.setRecordCount(records);
            this.page = page;
        }
        return rowDatas;
    }
}

