/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.object.client.ContractObjectEditor;
import ru.bitel.bgbilling.kernel.contract.object.client.ObjectModuleEditor;
import ru.bitel.bgbilling.kernel.contract.object.client.ObjectParamEditor;
import ru.bitel.bgbilling.kernel.contract.object.client.ObjectStatusEditor;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.common.model.Id;

public class ObjectEditor
extends BGPanel {
    private BGTextField objectTitle = new BGTextField(50);
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private JTabbedPane tabPanel = new JTabbedPane();
    private ObjectParamEditor paramEditor = new ObjectParamEditor();
    private ObjectStatusEditor statusEditor = new ObjectStatusEditor();
    private ObjectModuleEditor moduleEditor = new ObjectModuleEditor();

    public ObjectEditor() {
        this.jbInit();
    }

    private void jbInit() {
        this.statusEditor.addPropertyChangeListener(e -> {
            if ("statusUpdate".equals(e.getPropertyName())) {
                this.firePropertyChange("statusUpdate", e.getOldValue(), e.getNewValue());
            }
        });
        this.tabPanel.add((Component)this.paramEditor, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
        this.tabPanel.add((Component)this.statusEditor, "\u0421\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
        this.tabPanel.add((Component)this.moduleEditor, "\u041c\u043e\u0434\u0443\u043b\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
        this.tabPanel.addChangeListener(e -> this.setData());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 5, 0, 5), 0, 0));
        this.add((Component)this.tabPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    private JPanel getTopPanel() {
        BGButton backButton = new BGButton("\u041a \u0441\u043f\u0438\u0441\u043a\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        backButton.addActionListener(e -> this.firePropertyChange("toList", false, true));
        JButton editButton = new JButton(ClientUtils.getIcon("edit"));
        editButton.addActionListener(e -> new ObjectTitlePeriodEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", new Id().setId(this.id)).open());
        Color bgColor = this.objectTitle.getBackground();
        this.objectTitle.setHorizontalAlignment(0);
        this.objectTitle.setEditable(false);
        this.objectTitle.setBackground(bgColor);
        this.period.setEnabled(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)backButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new BGTitleLabel("\u041e\u0431\u044a\u0435\u043a\u0442:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.objectTitle, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.period, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)editButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void setData() {
        try {
            ContractObject contractObject = this.getContext().getWebService(ContractObjectService.class, 0).contractObjectGet(this.getContext().getContractId(), this.id);
            if (contractObject != null) {
                this.period.setDateFrom(contractObject.getDateFrom());
                this.period.setDateTo(contractObject.getDateTo());
                this.objectTitle.setText(contractObject.getTitle());
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        Component component = this.tabPanel.getSelectedComponent();
        if (component instanceof BGPanel) {
            BGPanel panel = (BGPanel)component;
            panel.trySetData();
        } else if (component instanceof BGUPanel) {
            BGUPanel panel = (BGUPanel)component;
            panel.performAction("refresh");
        }
    }

    @Override
    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.paramEditor.init(module, moduleId);
        this.moduleEditor.init(module, moduleId);
    }

    public void setStatusList(List<Status> statusList) {
        this.statusEditor.setStatusList(statusList);
    }

    @Override
    public void setContractId(int id) {
        super.setContractId(id);
        this.paramEditor.setContractId(id);
        this.moduleEditor.setContractId(id);
    }

    @Override
    public void setId(int id) {
        super.setId(id);
        this.paramEditor.setId(id);
        this.statusEditor.setObjectId(id == 0 ? -1 : id);
        this.moduleEditor.setId(id);
    }

    public void setContractObjectEditor(ContractObjectEditor contractObjectEditor) {
        this.paramEditor.setContractObjectEditor(contractObjectEditor);
    }

    class ObjectTitlePeriodEditor
    extends BGEditorDialog<Id> {
        private ContractObject contractObject;
        private BGTextField title;
        private BGControlPanelPeriodNoB period;

        public ObjectTitlePeriodEditor(String title, Id data) {
            super(title, data);
            this.title = new BGTextField(50);
            this.period = new BGControlPanelPeriodNoB();
        }

        @Override
        public void doDialogPanel() {
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442a:", this.title);
            this.addFieldV("\u041f\u0435\u0440\u0438\u043e\u0434:", this.period);
            try {
                this.contractObject = ObjectEditor.this.getContext().getWebService(ContractObjectService.class, 0).contractObjectGet(ObjectEditor.this.getContext().getContractId(), ((Id)this.data).getId());
                this.title.setText(this.contractObject.getTitle());
                this.period.setDateFrom(this.contractObject.getDateFrom());
                this.period.setDateTo(this.contractObject.getDateTo());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        @Override
        public boolean doApply() throws Exception {
            try {
                this.contractObject.setTitle(this.title.getText());
                this.contractObject.setDateFrom(this.period.getDateFrom());
                this.contractObject.setDateTo(this.period.getDateTo());
                ObjectEditor.this.getContext().getWebService(ContractObjectService.class, 0).contractObjectUpdate(ObjectEditor.this.getContext().getContractId(), this.contractObject);
                ObjectEditor.this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
                return false;
            }
            return true;
        }
    }
}

