/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

class MultiEditor
implements TableCellEditor {
    private DefaultCellEditor textFieldEditor;
    private DefaultCellEditor currentEditor;

    public MultiEditor() {
        JTextField tf = new JTextField();
        tf.setBorder(new LineBorder(Color.darkGray));
        this.textFieldEditor = new DefaultCellEditor(tf){
            private String value;
            private boolean flNotAdded;
            {
                this.value = null;
                this.flNotAdded = true;
            }

            @Override
            public void addCellEditorListener(CellEditorListener l) {
                if (this.flNotAdded) {
                    this.editorComponent.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            value = ((JTextField)editorComponent).getText();
                        }
                    });
                    this.flNotAdded = false;
                }
                super.addCellEditorListener(l);
            }

            @Override
            public boolean stopCellEditing() {
                if (((JTextField)this.editorComponent).getText().equals(this.value)) {
                    this.cancelCellEditing();
                    return true;
                }
                this.fireEditingStopped();
                return true;
            }
        };
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component result = null;
        this.currentEditor = value instanceof String ? this.textFieldEditor : null;
        if (this.currentEditor != null) {
            result = this.currentEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        return result;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.currentEditor != null) {
            return this.currentEditor.getCellEditorValue();
        }
        return "";
    }

    public Component getComponent() {
        return this.currentEditor != null ? this.currentEditor.getComponent() : null;
    }

    @Override
    public boolean stopCellEditing() {
        return this.currentEditor != null ? this.currentEditor.stopCellEditing() : false;
    }

    @Override
    public void cancelCellEditing() {
        if (this.currentEditor != null) {
            this.currentEditor.cancelCellEditing();
        }
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return !(anEvent instanceof MouseEvent) || !((MouseEvent)anEvent).isControlDown();
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.currentEditor != null ? this.currentEditor.isCellEditable(anEvent) : false;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        if (this.currentEditor != null) {
            this.currentEditor.addCellEditorListener(l);
        }
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        if (this.currentEditor != null) {
            this.currentEditor.removeCellEditorListener(l);
        }
    }

    public void setClickCountToStart(int n) {
        if (this.currentEditor != null) {
            this.currentEditor.setClickCountToStart(n);
        }
    }

    public int getClickCountToStart() {
        return this.currentEditor != null ? this.currentEditor.getClickCountToStart() : 1;
    }
}

