/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.client;

import bitel.billing.module.common.BGComboBoxWithSearch;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.contract.AddressUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractFilter_Default;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrAddress;

public class ContractFilter_Address
extends ContractFilter_Default {
    protected BGComboBoxWithSearch street = new BGComboBoxWithSearch(2);
    protected BGComboBoxWithSearch house = new BGComboBoxWithSearch(0);
    protected IntTextField pod_TF = new IntTextField();
    protected BGTextField flat_TF = new BGTextField();
    protected BGTextField room_TF = new BGTextField();
    protected int selectedStreetId = -1;
    protected int selectedHouseId = -1;
    Iterable<Element> houses = null;

    public ContractFilter_Address(String type) {
        this.type = type;
        this.jbInit();
        this.addComponentListener(new FocusComponentListener());
    }

    private void jbInit() {
        this.street.addActionListener(e -> {
            if (((long)e.getModifiers() & 0x10L) > 0L) {
                this.streetEntered();
            }
        });
        this.street.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("fillText")) {
                this.fillStreetList(String.valueOf(e.getNewValue()));
            } else if (e.getPropertyName().equals("textEntered")) {
                this.streetEntered();
            } else if (e.getPropertyName().equals("resetAllText")) {
                this.flat_TF.setText("");
                this.room_TF.setText("");
                this.selectedHouseId = -1;
                this.selectedStreetId = -1;
                this.house.resetTextFromEditor();
            }
        });
        this.house.addActionListener(e -> {
            if (((long)e.getModifiers() & 0x10L) > 0L) {
                this.houseEntered();
            }
        });
        this.house.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("fillText")) {
                this.fillHouseList(String.valueOf(e.getNewValue()));
            } else if (e.getPropertyName().equals("textEntered")) {
                this.houseEntered();
            } else if (e.getPropertyName().equals("resetAllText")) {
                this.selectedHouseId = -1;
                this.flat_TF.setText("");
                this.room_TF.setText("");
            }
        });
        this.flat_TF.setColumns(10);
        this.flat_TF.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ContractFilter_Address.this.room_TF.setText("");
                if (e.getKeyChar() == '\n') {
                    FocusManager.getCurrentManager().focusNextComponent();
                    return;
                }
            }
        });
        this.room_TF.setColumns(10);
        this.room_TF.addKeyListener((KeyListener)new KeyAdapter(this){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    FocusManager.getCurrentManager().focusNextComponent();
                    return;
                }
            }
        });
        BGButton streetAllButton = new BGButton("*");
        streetAllButton.setFocusable(false);
        streetAllButton.setMargin(new Insets(2, 2, 2, 2));
        streetAllButton.addActionListener(e -> this.fillStreetList(""));
        JButton searchButton = new JButton("\u041d\u0430\u0439\u0442\u0438");
        searchButton.setName("find");
        searchButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (((JButton)e.getComponent()).getName().equals("find") && e.getKeyChar() == '\n') {
                    ContractFilter_Address.this.doFilter(true);
                    return;
                }
            }
        });
        searchButton.addActionListener(e -> this.doFilter(true));
        JPanel addressParams = new JPanel(new GridBagLayout());
        addressParams.setBorder((Border)new BGTitleBorder(" \u0423\u0441\u043b\u043e\u0432\u0438\u0435 "));
        addressParams.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        addressParams.add((Component)this.street, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        addressParams.add((Component)streetAllButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 5), 0, 0));
        JPanel addressSubPanel = new JPanel(new GridBagLayout());
        addressSubPanel.add((Component)new JLabel("\u0414\u043e\u043c [\u0434\u0440\u043e\u0431\u044c]:"), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        addressSubPanel.add((Component)this.house, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        addressSubPanel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0438\u0440\u0430:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        addressSubPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043d\u0430\u0442\u0430:"), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        addressSubPanel.add((Component)this.flat_TF, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 0), 0, 0));
        addressSubPanel.add((Component)this.room_TF, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        addressSubPanel.add((Component)searchButton, new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        addressParams.add((Component)addressSubPanel, new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        addressParams.add(Box.createVerticalStrut(1), new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.street.setEditable(true);
        this.house.setEditable(true);
        this.paramsList.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b "));
        this.setLayout(new GridBagLayout());
        this.add(addressParams, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.paramsList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void fillStreetList(String streetTitle) {
        String streetMask = null;
        String cityMask = null;
        int pos = streetTitle.indexOf(40);
        if (pos < 0) {
            streetMask = streetTitle.trim();
        } else {
            streetMask = streetTitle.substring(0, pos).trim();
            if (pos < streetTitle.length() - 1) {
                cityMask = streetTitle.substring(pos + 1).trim();
            }
        }
        this.street.initPopup(streetTitle);
        try {
            for (Street s : ((AddressService)this.getContext().getWebService(AddressService.class, 0)).streetSearch(0, streetMask, cityMask, new Page(1, 25))) {
                ComboBoxItem item = new ComboBoxItem(s.getId(), s.getTitle() + " (" + s.getCity().getTitle() + ")");
                item.put("cityId", (Object)String.valueOf(s.getCityId()));
                this.street.addItem((Object)item);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void fillHouseList(String houseTitle) {
        this.house.removeAllItems();
        if (this.houses != null) {
            ComboBoxItem selected = null;
            for (Element s : this.houses) {
                String houseItemTitle = XMLUtils.getAttribute((Element)s, (String)"house");
                if (houseTitle == null || houseItemTitle == null || !houseItemTitle.contains(houseTitle)) continue;
                ComboBoxItem comboBoxItem = new ComboBoxItem((Object)Integer.valueOf(XMLUtils.getAttribute((Element)s, (String)"id")), houseItemTitle);
                this.house.addItem((Object)comboBoxItem);
                if (!houseItemTitle.equalsIgnoreCase(houseTitle)) continue;
                selected = comboBoxItem;
            }
            if (selected != null) {
                this.house.setSelectedItem(selected);
            } else {
                this.house.insertItemAt((Object)new ComboBoxItem(0, houseTitle), 0);
                this.house.setSelectedIndex(0);
            }
        } else {
            this.house.addItem((Object)new ComboBoxItem(0, houseTitle));
            this.house.setSelectedIndex(0);
        }
    }

    private void streetEntered() {
        try {
            this.selectedStreetId = Utils.parseInt((String)this.street.getSelectedId());
            if (this.selectedStreetId > 0) {
                this.fillListByHouses(this.selectedStreetId);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void houseEntered() {
        this.selectedHouseId = !this.house.getSelectedId().equals("") ? Integer.valueOf(this.house.getSelectedId()) : -1;
    }

    private void fillListByHouses(int streetId) throws Exception {
        if (streetId > 0) {
            Request request = new Request();
            request.setModule("admin");
            request.setAction("FilterHouse");
            request.setAttribute("street", streetId);
            Document doc = this.getDocument(request);
            this.houses = XMLUtils.selectElements((Node)doc, (String)"data/list/item");
        } else {
            this.houses = null;
        }
    }

    @Override
    public void doFilter(boolean new_page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parameters", this.paramsList.getListValues());
        ComboBoxItem comboBoxItem = (ComboBoxItem)this.street.getSelectedItem();
        if (comboBoxItem == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0443\u043b\u0438\u0446\u0443");
        } else {
            int cityId = Utils.parseInt((String)((String)comboBoxItem.get("cityId")), (int)0);
            if (this.selectedStreetId > 0 || cityId > 0) {
                params.put("city", cityId);
                params.put("street", this.selectedStreetId);
                if (this.selectedHouseId > 0) {
                    params.put("houseId", this.selectedHouseId);
                } else {
                    Object houseItem = this.house.getSelectedItem();
                    if (houseItem != null) {
                        params.put("house", AddressUtil.getHouse((String)houseItem.toString()));
                        params.put("frac", AddressUtil.getHouseFrac((String)houseItem.toString()));
                    }
                }
                params.put("flat", this.flat_TF.getText());
                params.put("room", this.room_TF.getText());
                this.openPanel.doFilter(params, this.type, new_page);
            }
        }
    }

    public FilterEntityAttrAddress getFilter() {
        if (this.street.getSelectedItem() == null) {
            return null;
        }
        int cityId = Utils.parseInt((String)((String)((ComboBoxItem)this.street.getSelectedItem()).get("cityId")), (int)0);
        if (cityId > 0) {
            return new FilterEntityAttrAddress(new HashSet(this.paramsList.getListIds()), cityId, this.selectedStreetId, AddressUtil.getHouse((String)(this.house.getSelectedItem() != null ? ((ComboBoxItem)this.house.getSelectedItem()).toString() : "")), AddressUtil.getHouseFrac((String)(this.house.getSelectedItem() != null ? ((ComboBoxItem)this.house.getSelectedItem()).toString() : "")), (int)this.pod_TF.getValue(), this.flat_TF.getText(), this.room_TF.getText());
        }
        return null;
    }

    @Override
    public void setParametersList(Element el) {
        this.setParameters(el, String.valueOf(this.type), true, false);
    }

    class FocusComponentListener
    implements ComponentListener {
        FocusComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ContractFilter_Address.this.street.requestFocus(true);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

