/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserPermitionsManager;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSActionGroup;
import ru.bitel.common.Utils;

public class BGSActionGroupDao
extends AbstractIdDao<BGSActionGroup> {
    private UserPermitionsManager userPermitionsManager;

    public BGSActionGroupDao(Connection con) {
        super(con, 0, "bgs_action_group");
        this.userPermitionsManager = new UserPermitionsManager(con);
    }

    public List<BGSActionGroup> getList() throws SQLException {
        return this.list(null, null, new Object[0]);
    }

    public List<BGSActionGroup> getByIds(String actionGroupIds) throws SQLException {
        ArrayList<BGSActionGroup> result = new ArrayList<BGSActionGroup>();
        if (Utils.isBlankString(actionGroupIds)) {
            return result;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + actionGroupIds + ")";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        return result;
    }

    @Override
    protected BGSActionGroup getFromRS(ResultSet rs) throws SQLException {
        BGSActionGroup actionGroup = new BGSActionGroup();
        int id = rs.getInt("id");
        actionGroup.setId(id);
        actionGroup.setTitle(rs.getString("title"));
        actionGroup.setActions(this.userPermitionsManager.getActions(id, false));
        return actionGroup;
    }

    @Override
    protected void updateImpl(BGSActionGroup actionGroup) throws SQLException {
        String querySet = "title=?, bgs_action_ids=?";
        try (PreparedStatement ps = this.prepareStatement(actionGroup, querySet);){
            String actions = actionGroup.getActions() == null ? "" : Utils.toString(actionGroup.getActions().stream().map(BGSAction::getId).toList(), ",");
            int index = 1;
            ps.setString(index++, actionGroup.getTitle());
            ps.setString(index++, actions);
            this.executeUpdate(actionGroup, index, ps);
        }
        this.userPermitionsManager.updateUserActions(actionGroup.getId(), actionGroup.getActions(), false);
    }
}

