/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.auth;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.auth.ModuleAuth;
import ru.bitel.bgbilling.kernel.auth.ModuleAuthImpl;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class AuthModes {
    private static Logger logger = LoggerFactory.getLogger(AuthModes.class);
    private static final String passwordless = Utils.randomAlphanumeric((int)64);

    public static long loadConfig(Setup setup, long setupInitDate, Map<Integer, List<Integer>> authModes) {
        if (setupInitDate < setup.getInitDate().getTime()) {
            HashMap newAuthModes = new HashMap();
            String modes = setup.get("web.auth.modes", null);
            if (modes != null) {
                String[] parts = modes.split(";");
                for (int i = 0; i < parts.length; ++i) {
                    String[] mid_mode = parts[i].split(":");
                    if (mid_mode.length != 2) continue;
                    int mid = Utils.parseInt((String)mid_mode[0].trim(), (int)0);
                    int mode = Utils.parseInt((String)mid_mode[1].trim(), (int)0);
                    if (!newAuthModes.containsKey(mid)) {
                        newAuthModes.put(mid, new ArrayList());
                    }
                    ((List)newAuthModes.get(mid)).add(mode);
                }
            }
            if (authModes != null) {
                authModes.clear();
                authModes.putAll(newAuthModes);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Web auth modes:");
                for (Map.Entry<Integer, List<Integer>> me : authModes.entrySet()) {
                    logger.debug("\t" + String.valueOf(me.getKey()) + " => " + String.valueOf(me.getValue()));
                }
            }
            setupInitDate = setup.getInitDate().getTime();
        }
        return setupInitDate;
    }

    public static ModuleUser findModuleUserUserByLogin(String login, String authModuleId, Map<Integer, List<Integer>> authModes) {
        ModuleUser moduleUser = null;
        List midAuthList = Utils.toIntegerList((String)authModuleId);
        if (midAuthList.size() == 0) {
            midAuthList.add(0);
        }
        Iterator iterator = midAuthList.iterator();
        block2: while (iterator.hasNext()) {
            int authMode;
            int moduleId = (Integer)iterator.next();
            List<Integer> authModeList = authModes.get(moduleId);
            if (authModeList == null) continue;
            Iterator<Integer> iterator2 = authModeList.iterator();
            while (iterator2.hasNext() && (authMode = iterator2.next().intValue()) != 0) {
                try {
                    moduleUser = AuthModes.findModuleUserUserByLogin(login, moduleId, authMode);
                }
                catch (Exception ex) {
                    logger.error("error findModuleUserUserByLogin", (Throwable)ex);
                }
                if (moduleUser == null) continue;
                break block2;
            }
        }
        return moduleUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleUser findModuleUserUserByLogin(String login, int moduleId, Integer authMode) {
        ModuleUser moduleUser;
        block13: {
            moduleUser = null;
            Setup setup = Setup.getSetup();
            Connection conSlave = setup.getDBSlaveConnectionFromPool();
            try {
                if (moduleId == 0) {
                    String className = setup.get("web.auth.class", ModuleAuthImpl.class.getName());
                    ModuleAuth moduleAuth = null;
                    try {
                        moduleAuth = Class.forName(className).asSubclass(ModuleAuth.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (moduleAuth == null) {
                        moduleAuth = DynamicClassManager.getInstance().newInstance(ModuleAuth.class, className);
                    }
                    if (moduleAuth != null) {
                        moduleUser = moduleAuth.findModuleUserByLogin(login, moduleId, authMode, conSlave);
                    } else {
                        logger.error("error load class web.auth.class={}", (Object)className);
                    }
                    break block13;
                }
                if (moduleId <= 0) break block13;
                BGModule module = ModuleCache.getInstance().getModule(moduleId);
                if (module == null) {
                    throw new BGException("Not found module with id=" + moduleId);
                }
                ModuleAuth ma = ModuleCache.getInstance().getAuthModule(module.getName());
                if (ma != null) {
                    moduleUser = ma.findModuleUserByLogin(login, moduleId, authMode, conSlave);
                    break block13;
                }
                throw new BGException("Not found module auth for module " + moduleId);
            }
            catch (Exception ex) {
                logger.error("error find module user by login", (Throwable)ex);
            }
            finally {
                ServerUtils.closeConnection(conSlave);
            }
        }
        return moduleUser;
    }

    public static String passwordless() {
        return passwordless;
    }
}

