/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.event.Level;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionLog;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.SessionFlushingManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetConnectionDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaConnectionCloseEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaOptionsModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasConnection;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class InetConnectionCallRuntime
extends InetConnectionRuntime {
    public final long connectionId;
    public final InetNasConnection nasConnection;
    public final String realm;
    private final boolean serviceSession;
    private final InetConnectionCallRuntime parentConnectionCallRuntime;
    private List<InetConnectionCallRuntime> serviceConnections;
    public long nextCloseBySessionCountMillis = 0L;
    private long inetOptionsMillis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetConnectionCallRuntime(Accounting accounting, InetServRuntime inetServRuntime, InetConnection connection, InetSession session, String realm, NasList<InetNasConnection, InetNas> nasList, int nasId, int nasPort, boolean serviceSession, InetConnectionCallRuntime parentConnectionCallRuntime) throws BGException {
        super(accounting, true, inetServRuntime, connection, session);
        this.connectionId = connection.getId();
        if (nasList != null) {
            this.nasConnection = new InetNasConnection(nasList, nasId, nasPort);
            this.nasConnection.setSession(this);
            this.nasConnection.setStatus(NasConnection.Status.working);
        } else {
            this.nasConnection = null;
        }
        this.serviceSession = serviceSession;
        this.parentConnectionCallRuntime = parentConnectionCallRuntime;
        this.realm = realm;
        if (parentConnectionCallRuntime != null && connection.getConnectionStatus() < 3) {
            parentConnectionCallRuntime.inetServRuntime.lock();
            try {
                String username = InetUtils.internServiceName(connection.getUsername());
                connection.setUsername(username);
                parentConnectionCallRuntime.addServiceConnection(username, this);
            }
            finally {
                parentConnectionCallRuntime.inetServRuntime.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionStop(Date sessionStop, long finishTimeout) {
        super.connectionStop(sessionStop, finishTimeout);
        if (this.parentConnectionCallRuntime != null) {
            this.parentConnectionCallRuntime.inetServRuntime.lock();
            try {
                this.parentConnectionCallRuntime.removeServiceConnection(this.connection.getUsername(), this);
            }
            finally {
                this.parentConnectionCallRuntime.inetServRuntime.unlock();
            }
        }
    }

    private void addServiceConnection(String name, InetConnectionCallRuntime connectionRuntime) {
        assert (this.inetServRuntime.isHeldByCurrentThread());
        if (this.serviceConnections == null) {
            this.serviceConnections = new ArrayList<InetConnectionCallRuntime>(3);
        }
        this.serviceConnections.add(connectionRuntime);
    }

    private void removeServiceConnection(String name, InetConnectionCallRuntime connectionRuntime) {
        assert (this.inetServRuntime.isHeldByCurrentThread());
        if (this.serviceConnections != null) {
            int size = this.serviceConnections.size();
            for (int i = 0; i < size; ++i) {
                if (this.serviceConnections.get((int)i).connectionId != connectionRuntime.connectionId) continue;
                this.serviceConnections.remove(i);
                break;
            }
            if (this.serviceConnections.size() == 0) {
                this.serviceConnections = null;
            }
        }
    }

    public List<InetConnectionCallRuntime> getServiceConnections() {
        return this.serviceConnections;
    }

    @Override
    public boolean isServiceSession() {
        return this.serviceSession;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean tryFinish(Accounting accounting, ConnectionSet connectionSet, BalanceDao balanceDao, long nowSeconds, long nowMillis) throws BGException {
        block28: {
            block27: {
                if (!InetConnectionCallRuntime.$assertionsDisabled && !this.inetServRuntime.isHeldByCurrentThread()) {
                    throw new AssertionError();
                }
                if (this.connection == null) {
                    return false;
                }
                lastAccountTime = this.lastAccountTime;
                lastFlowTime = this.lastFlowTime;
                deviceId = this.connection.getDeviceId();
                deviceRuntime = accounting.deviceMap.get(deviceId);
                needStop = false;
                sessionStop = this.sessionStop;
                if (sessionStop != null && !TimeUtils.dateEqual((Date)sessionStop, (Date)this.sessionStart)) {
                    calendar = new GregorianCalendar();
                    calendar.setTime(this.sessionStart);
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
                    calendar.add(5, 1);
                    calendar.add(14, -1);
                    if (sessionStop.getTime() - calendar.getTimeInMillis() > TimeUnit.MINUTES.toMillis(3L)) {
                        sessionStop = calendar.getTime();
                    }
                }
                v0 = sessionStopTime = sessionStop != null ? sessionStop.getTime() / 1000L : 0L;
                if (this.nasConnection == null) break block27;
                switch (1.$SwitchMap$ru$bitel$bgbilling$kernel$network$radius$nas$NasConnection$Status[this.nasConnection.getStatus().ordinal()]) {
                    case 1: {
                        if (sessionStop != null) {
                            if (sessionStopTime > nowSeconds - deviceRuntime.connectionFinishTimeout) {
                                return false;
                            }
                            ConnectionLog.log(this, Level.INFO, "Finish call connection with sessionStop!=null by sessionFinishTimeout");
                        } else {
                            if (lastAccountTime > nowSeconds - this.getSuspendTimeout(deviceRuntime)) {
                                return false;
                            }
                            if (deviceRuntime.connectionCloseTimeoutCheckFlow && lastFlowTime > nowSeconds - this.getSuspendTimeout(deviceRuntime)) {
                                return false;
                            }
                            ConnectionLog.log(this, Level.INFO, "Suspend call connection by sessionSuspendTimeout");
                            this.nasConnection.setStatus(NasConnection.Status.suspended);
                            return false;
                        }
                    }
                    case 2: {
                        if (sessionStop != null) ** GOTO lbl48
                        if (lastAccountTime > nowSeconds - this.getCloseTimeout(deviceRuntime)) {
                            return false;
                        }
                        if (deviceRuntime.connectionCloseTimeoutCheckFlow && lastFlowTime > nowSeconds - this.getCloseTimeout(deviceRuntime)) {
                            return false;
                        }
                        ConnectionLog.log(this, Level.INFO, "Close suspended call connection by sessionCloseTimeout");
                        InetConnection.setType((InetConnection)this.connection, (int)4, (boolean)true);
                        needStop = true;
                        if (deviceRuntime.connectionCloseTimeoutForceClose) {
                            EventProcessor.getInstance().publish((Event)new InetSaConnectionCloseEvent(accounting.moduleId, 0, this.connection));
                        }
                        break block28;
lbl48:
                        // 1 sources

                        if (sessionStopTime > nowSeconds - deviceRuntime.connectionFinishTimeout) {
                            return false;
                        }
                        ConnectionLog.log(this, Level.INFO, "Finish suspended call connection by sessionFinishTimeout");
                    }
                    case 3: {
                        if (sessionStop != null) {
                            if (sessionStopTime > nowSeconds - deviceRuntime.connectionFinishTimeout) {
                                return false;
                            }
                            ConnectionLog.log(this, Level.INFO, "Finish stopped call connection by sessionFinishTimeout");
                        } else {
                            if (lastFlowTime > nowSeconds - deviceRuntime.connectionFinishTimeout) {
                                return false;
                            }
                            ConnectionLog.log(this, Level.INFO, "Finish stopped call connection by sessionFinishTimeout");
                        }
                        break block28;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (sessionStop == null) {
                if (lastAccountTime > nowSeconds - this.getCloseTimeout(deviceRuntime)) {
                    return false;
                }
                if (deviceRuntime.connectionCloseTimeoutCheckFlow && lastFlowTime > nowSeconds - this.getCloseTimeout(deviceRuntime)) {
                    return false;
                }
                ConnectionLog.log(this, Level.INFO, "Close event connection by sessionCloseTimeout");
                needStop = true;
            } else {
                if (sessionStopTime > nowSeconds - deviceRuntime.connectionFinishTimeout) {
                    return false;
                }
                ConnectionLog.log(this, Level.INFO, "Finish event connection by sessionFinishTimeout");
            }
        }
        this.finish(accounting, connectionSet, balanceDao, needStop, nowMillis, false);
        return true;
    }

    @Override
    public void forceStop(Accounting accounting, ConnectionSet connectionSet, long millis, boolean force) throws BGException {
        Connection con = connectionSet.getConnection();
        if (this.call && this.nasConnection != null) {
            ((InetNas)this.nasConnection.getNas()).stopConnection(con, this.nasConnection, 0L, true, millis, force);
        } else {
            accounting.connectionStop(con, true, this, new Date(millis), 0L);
        }
        connectionSet.commit();
    }

    @Override
    public void finish(Accounting accounting, ConnectionSet connectionSet, BalanceDao balanceDao, boolean needStop, long nowMillis, boolean force) throws BGException {
        boolean check;
        assert (this.inetServRuntime.isHeldByCurrentThread());
        try {
            List<InetConnectionCallRuntime> serviceConnections = this.getServiceConnections();
            if (serviceConnections != null) {
                serviceConnections = new ArrayList<InetConnectionCallRuntime>(serviceConnections);
                for (InetConnectionCallRuntime connection : serviceConnections) {
                    connection.finish(accounting, connectionSet, balanceDao, connection.sessionStop == null, nowMillis, force);
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        if (needStop) {
            this.forceStop(accounting, connectionSet, nowMillis, force);
        }
        ConnectionLog.log(this, Level.INFO, "Finishing call session with lastActive=" + String.valueOf(new Date(Math.max(this.lastAccountTime, this.lastFlowTime) * 1000L)));
        InetConnection connection = this.connection;
        boolean bl = check = needStop && connection.getConnectionStatus() < 3;
        if (accounting.sessionFinish(connectionSet, balanceDao, this, true, check, force)) {
            connection.setConnectionStatus(4);
            connectionSet.commit();
        }
    }

    @Override
    public boolean trySplitSession(Accounting accounting, Long hour, long millis) throws BGException {
        assert (this.inetServRuntime.isHeldByCurrentThread());
        if (this.parentConnectionCallRuntime != null) {
            return this.parentConnectionCallRuntime.trySplitSession(accounting, hour, millis);
        }
        return super.trySplitSession(accounting, hour, millis);
    }

    @Override
    public boolean splitSession(Accounting accounting, Long hour, long millis, boolean setAccountingPeriod) throws BGException {
        ConnectionSet connectionSet = ((DefaultContext)ThreadContext.get(DefaultContext.class)).getConnectionSet();
        try {
            List<InetConnectionCallRuntime> serviceConnections;
            assert (!this.isServiceSession());
            assert (this.inetServRuntime.isHeldByCurrentThread());
            Connection con = connectionSet.getConnection();
            InetSessionDao inetSessionDao = new InetSessionDao(con, accounting.moduleId);
            this.splitSessionImpl(accounting, connectionSet, con, inetSessionDao, hour, millis, setAccountingPeriod, 0L);
            if (setAccountingPeriod) {
                this.setAccountingPeriod(accounting, connectionSet, millis, true);
            }
            if ((serviceConnections = this.getServiceConnections()) != null) {
                for (InetConnectionCallRuntime connection : serviceConnections) {
                    if (connection.sessionStartTime >= millis) continue;
                    connection.splitSessionImpl(accounting, connectionSet, con, inetSessionDao, hour, millis, setAccountingPeriod, this.sessionId);
                    if (!setAccountingPeriod) continue;
                    connection.setAccountingPeriod(accounting, connectionSet, millis, true);
                    if (connection.accountingPeriodId > 0) continue;
                }
            }
            connectionSet.commit();
            return true;
        }
        catch (Exception ex) {
            this.logError(ex);
            return false;
        }
    }

    @Override
    public void addTraffic(int agentDeviceId, Long hour, Integer trafficTypeId, long amount) {
        InetConnectionCallRuntime parentConnectionCallRuntime = this.getParentConnectionCallRuntime();
        boolean addToCalculate = parentConnectionCallRuntime != null ? parentConnectionCallRuntime.sessionDeviceState == InetServState.STATE_ENABLE.getCode() : this.sessionDeviceState == InetServState.STATE_ENABLE.getCode();
        this.addTraffic(agentDeviceId, hour, trafficTypeId, amount, addToCalculate);
    }

    @Override
    public void addTraffics(int agentDeviceId, Long hour, Map<Integer, AccountingTrafficAmount> traffics) {
        InetConnectionCallRuntime parentConnectionCallRuntime = this.getParentConnectionCallRuntime();
        boolean addToCalculate = parentConnectionCallRuntime != null ? parentConnectionCallRuntime.sessionDeviceState == InetServState.STATE_ENABLE.getCode() : this.sessionDeviceState == InetServState.STATE_ENABLE.getCode();
        this.addTraffics(agentDeviceId, hour, traffics, addToCalculate);
    }

    private boolean canStateModify(long now) {
        if (this.kill) {
            long div = now - this.killMillis;
            long connectionStartDiv = this.killMillis - this.connectionStartTime;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("canStateModify: now = " + now + "; div = " + div + "; connectionStartDiv=" + connectionStartDiv);
            }
            if (connectionStartDiv < TimeUnit.MINUTES.toMillis(60L)) {
                if (connectionStartDiv < TimeUnit.MINUTES.toMillis(4L)) {
                    if (connectionStartDiv < TimeUnit.SECONDS.toMillis(80L)) {
                        if (connectionStartDiv < TimeUnit.SECONDS.toMillis(30L)) {
                            if (div > TimeUnit.SECONDS.toMillis(6L)) {
                                this.kill = false;
                            }
                        } else if (div > TimeUnit.SECONDS.toMillis(20L)) {
                            this.kill = false;
                        }
                    } else if (div > TimeUnit.SECONDS.toMillis(55L)) {
                        this.kill = false;
                    }
                } else if (div > TimeUnit.MINUTES.toMillis(30L)) {
                    this.kill = false;
                }
            } else if (div > TimeUnit.HOURS.toMillis(3L)) {
                this.kill = false;
            }
        }
        return !this.kill;
    }

    @Override
    public boolean processAccessCode(Accounting application, ConnectionSet connectionSet, int accessCode) throws BGException {
        if (this.parentConnectionCallRuntime != null) {
            return this.parentConnectionCallRuntime.processAccessCode(application, connectionSet, accessCode);
        }
        InetServ parentInetServ = this.inetServRuntime.getParentInetServ(application);
        long now = System.currentTimeMillis();
        if (this.sessionDeviceState == InetServState.STATE_ENABLE.getCode()) {
            if (accessCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                ConnectionLog.log(this, Level.INFO, "Found error " + accessCode);
                if (this.canStateModify(now)) {
                    ConnectionLog.log(this, Level.INFO, "Sending event to stop session...");
                    this.tryFlush(application, connectionSet, parentInetServ);
                    EventProcessor ep = EventProcessor.getInstance();
                    ep.publish((Event)new InetSaStateModifyEvent(application.moduleId, 0, this.connection, InetServState.STATE_DISABLE.getCode(), accessCode));
                    this.kill = true;
                    this.killMillis = now;
                } else {
                    ConnectionLog.log(this, Level.INFO, "Already sent event to stop session.");
                }
                return true;
            }
        } else if (accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
            ConnectionLog.log(this, Level.INFO, "inetServ[id=" + this.inetServRuntime.getInetServ().getId() + "] connection should be enabled.");
            if (this.canStateModify(now)) {
                ConnectionLog.log(this, Level.INFO, "Sending event to enable session...");
                EventProcessor ep = EventProcessor.getInstance();
                ep.publish((Event)new InetSaStateModifyEvent(application.moduleId, 0, this.connection, InetServState.STATE_ENABLE.getCode(), accessCode));
                this.kill = true;
                this.killMillis = now;
            } else {
                ConnectionLog.log(this, Level.INFO, "Already sent event to enable session.");
            }
            return true;
        }
        return false;
    }

    private void tryFlush(Accounting accounting, ConnectionSet connectionSet, InetServ parentInetServ) throws BGException {
        InetDeviceRuntime deviceRuntime = accounting.deviceMap.get(this.connection.getDeviceId());
        if (deviceRuntime == null || !deviceRuntime.connectionCloseForceFlush) {
            return;
        }
        this.getLogger().debug("Flushing to DB");
        try (BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());
             SessionFlushingManager sessionFlushingManager = new SessionFlushingManager(accounting, false);){
            sessionFlushingManager.flush(connectionSet.getConnection(), balanceDao, this, false, false, false, true, System.currentTimeMillis(), false);
        }
        connectionSet.commit();
    }

    private boolean canOptionsModify(long now) {
        long div = now - this.inetOptionsMillis;
        long connectionStarDiv = this.inetOptionsMillis - this.connectionStartTime;
        return connectionStarDiv < TimeUnit.HOURS.toMillis(1L) ? (connectionStarDiv < TimeUnit.MINUTES.toMillis(4L) ? (connectionStarDiv < TimeUnit.SECONDS.toMillis(80L) ? (connectionStarDiv < TimeUnit.SECONDS.toMillis(30L) ? div > TimeUnit.SECONDS.toMillis(6L) : div > TimeUnit.SECONDS.toMillis(20L)) : div > TimeUnit.SECONDS.toMillis(45L)) : div > TimeUnit.MINUTES.toMillis(30L)) : div > TimeUnit.HOURS.toMillis(3L);
    }

    @Override
    public boolean processInetOptions(InetApplication application, Set<Integer> newOptions, String source) throws BGException {
        if (this.parentConnectionCallRuntime != null) {
            this.getLogger().warn("Call processInetOptions to service session");
            return false;
        }
        if (!this.inetOptions.equals(newOptions)) {
            this.inetOptions = newOptions;
            this.sendInetOptions(application, this.inetOptions, System.currentTimeMillis(), source);
            return true;
        }
        Set deviceOptions = this.connection.getDeviceOptions();
        if (deviceOptions == null || newOptions.equals(deviceOptions)) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.canOptionsModify(now)) {
            this.sendInetOptions(application, this.inetOptions, now, source);
            return true;
        }
        return false;
    }

    private void sendInetOptions(InetApplication application, Set<Integer> newOptions, long now, String source) throws BGException {
        this.inetOptionsMillis = now;
        ConnectionLog.log(this, Level.INFO, "Sending events to modify serv & connection options to: " + Utils.toString(newOptions));
        EventProcessor ep = EventProcessor.getInstance();
        InetSaOptionsModifyEvent inetSaOptionsModifyEvent = new InetSaOptionsModifyEvent(application.moduleId, 0, this.inetServRuntime.getParentInetServ(application), newOptions);
        inetSaOptionsModifyEvent.setSource((String)(source != null ? source + ":" : "") + InetConnectionCallRuntime.class.getSimpleName());
        ep.publish((Event)inetSaOptionsModifyEvent);
        inetSaOptionsModifyEvent = new InetSaOptionsModifyEvent(application.moduleId, 0, this.connection, newOptions);
        inetSaOptionsModifyEvent.setSource((String)(source != null ? source + ":" : "") + InetConnectionCallRuntime.class.getSimpleName());
        ep.publish((Event)inetSaOptionsModifyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDeviceState(InetApplication application, ConnectionSet connectionSet, Short deviceState) throws BGException {
        if (this.parentConnectionCallRuntime != null) {
            this.getLogger().info("Set deviceState to parentConnection");
            return this.parentConnectionCallRuntime.setDeviceState(application, connectionSet, deviceState);
        }
        if (!this.serviceSession && deviceState.shortValue() != InetServState.STATE_NULL.getCode()) {
            boolean result = false;
            this.inetServRuntime.lock();
            try {
                InetConnection connection = this.connection;
                this.getLogger().info("Set deviceState for connection:" + this.connectionId);
                if (connection.getDeviceState() != deviceState.shortValue()) {
                    result = true;
                    this.getLogger().info("Changing deviceState to " + deviceState);
                    this.kill = false;
                    connection.setDeviceState(deviceState.shortValue());
                    InetConnection.setType((InetConnection)connection, (int)8, (boolean)true);
                    InetConnectionDao connectionDao = new InetConnectionDao(connectionSet.getConnection(), application.moduleId);
                    connectionDao.updateDeviceStateAndOptions(connection.getDeviceId(), connection.getId(), deviceState.shortValue(), null, connection.getAccessCode());
                    connectionSet.commit();
                    EventProcessor.getInstance().publish((Event)new InetConnectionDeviceStateAndOptionsModifiedEvent(application.moduleId, connection.getDeviceId(), connection.getServId(), connection.getId(), deviceState.shortValue(), null));
                } else {
                    this.getLogger().info("Connection:" + this.connectionId + " deviceState already " + deviceState);
                }
            }
            finally {
                this.inetServRuntime.unlock();
            }
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceOptions(InetApplication application, ConnectionSet connectionSet, Set<Integer> deviceOptions) throws BGException {
        if (this.parentConnectionCallRuntime != null) {
            this.getLogger().info("Set deviceState to parentConnection");
            this.parentConnectionCallRuntime.setDeviceOptions(application, connectionSet, deviceOptions);
        } else if (!this.serviceSession && deviceOptions != null) {
            this.inetServRuntime.lock();
            try {
                InetConnection connection = this.connection;
                this.getLogger().info("Set deviceOptions for connection:" + this.connectionId);
                if (connection.getDeviceOptions() == null || !connection.getDeviceOptions().equals(deviceOptions)) {
                    this.getLogger().info("Changing deviceOptions to " + String.valueOf(deviceOptions));
                    this.kill = false;
                    InetConnectionDao connectionDao = new InetConnectionDao(connectionSet.getConnection(), application.moduleId);
                    connectionDao.updateDeviceStateAndOptions(connection.getDeviceId(), connection.getId(), InetServState.STATE_NULL.getCode(), deviceOptions, connection.getAccessCode());
                    connectionSet.commit();
                    EventProcessor.getInstance().publish((Event)new InetConnectionDeviceStateAndOptionsModifiedEvent(application.moduleId, connection.getDeviceId(), connection.getServId(), connection.getId(), InetServState.STATE_NULL.getCode(), deviceOptions));
                } else {
                    this.getLogger().info("Connection:" + this.connectionId + " deviceOptions already " + String.valueOf(deviceOptions));
                }
            }
            finally {
                this.inetServRuntime.unlock();
            }
        }
    }

    public InetConnectionCallRuntime getParentConnectionCallRuntime() {
        return this.parentConnectionCallRuntime;
    }

    @Override
    public long getSuspendTimeout(InetDeviceRuntime deviceRuntime) {
        if (this.parentConnectionCallRuntime != null && this.parentConnectionCallRuntime != this) {
            return this.parentConnectionCallRuntime.getSuspendTimeout(deviceRuntime);
        }
        if (this.serviceSession) {
            return deviceRuntime.connectionSuspendTimeout;
        }
        InetServTypeRuntime inetServTypeRuntime = this.inetServRuntime.getInetServTypeRuntime();
        if (this.sessionDeviceState == InetServState.STATE_DISABLE.getCode()) {
            if (inetServTypeRuntime.connectionDisableSuspendTimeout != null) {
                return inetServTypeRuntime.connectionDisableSuspendTimeout;
            }
            return deviceRuntime.connectionDisableSuspendTimeout;
        }
        if (inetServTypeRuntime.connectionSuspendTimeout != null) {
            return inetServTypeRuntime.connectionSuspendTimeout;
        }
        return deviceRuntime.connectionSuspendTimeout;
    }

    @Override
    public long getCloseTimeout(InetDeviceRuntime deviceRuntime) {
        if (this.parentConnectionCallRuntime != null && this.parentConnectionCallRuntime != this) {
            return this.parentConnectionCallRuntime.getCloseTimeout(deviceRuntime);
        }
        if (this.serviceSession) {
            return deviceRuntime.connectionCloseTimeout;
        }
        InetServTypeRuntime inetServTypeRuntime = this.inetServRuntime.getInetServTypeRuntime();
        if (this.sessionDeviceState == InetServState.STATE_DISABLE.getCode()) {
            if (inetServTypeRuntime.connectionDisableCloseTimeout != null) {
                return inetServTypeRuntime.connectionDisableCloseTimeout;
            }
            return deviceRuntime.connectionDisableCloseTimeout;
        }
        if (inetServTypeRuntime.connectionCloseTimeout != null) {
            return inetServTypeRuntime.connectionCloseTimeout;
        }
        return deviceRuntime.connectionCloseTimeout;
    }

    @Override
    public void forceFinish(Accounting accounting, ConnectionSet connectionSet, BalanceDao balanceDao, boolean needStop, long currentTimeMillis) throws BGException {
        assert (this.inetServRuntime.isHeldByCurrentThread());
        this.finish(accounting, connectionSet, balanceDao, needStop, currentTimeMillis, true);
    }

    @Override
    public String getRealm() {
        if (this.serviceSession && this.parentConnectionCallRuntime != null) {
            return this.parentConnectionCallRuntime.realm;
        }
        return this.realm;
    }

    @Override
    public String getAcctService() {
        if (this.serviceSession) {
            return this.getUserName();
        }
        return null;
    }
}

