/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.contract;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.inet.client.contract.InetServForm;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetAddressType;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.inet.IpRange;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceAddress;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceInstance;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class InetServAddressDialog
extends BGEditorDialog<IpResource> {
    public static final int MODE_ADDRESS = 0;
    public static final int MODE_NET = 1;
    public static final int MODE_ANY = 2;
    public static final int MODE_RANGE = 3;
    private int mode = 2;
    private int deviceId;
    private int interfaceId;
    private int mask = 32;
    private int range = 1;
    private boolean lockSelection = false;
    private ClientContext context = null;
    private InetServForm inetServForm = null;
    private InetServForm.ParamRowData paramRowData = null;
    private InetServService inetServService = null;
    private ResourceService resourceService = null;
    private List<Integer> ipResourceCategoryIds = null;
    private BGIntTextField maskRange = new BGIntTextField();
    private BGIntTextField maxField = new BGIntTextField(5);
    private JTextField filter = new JTextField(25);
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    private BGComboBox<ComboBoxItem> rangeCb = new BGComboBox();
    private IpCategoryTreeModel treeModel = new IpCategoryTreeModel();
    private BGUTreeTable treeTable = new BGUTreeTable((BGTreeTableModel)this.treeModel);
    private BGUList<IpResource> ipResourceList = new BGUList();
    private BGUList<IpResourceInstance> result = new BGUList();

    public InetServAddressDialog(String title, int mode, int deviceId, int interfaceId, InetServForm inetServForm, InetServForm.ParamRowData paramRowData, ClientContext context) {
        super(title, null);
        this.mode = mode;
        this.context = context;
        this.deviceId = deviceId;
        this.interfaceId = interfaceId;
        this.inetServForm = inetServForm;
        this.paramRowData = paramRowData;
    }

    public void doDialogPanel() {
        this.panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getResourcePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        try {
            InetServType inetServType = (InetServType)this.inetServForm.serviceType.getSelectedItem();
            this.ipResourceCategoryIds = this.getInetServService().ipResourceCategoryIds(this.deviceId, this.interfaceId, inetServType != null ? inetServType.getId() : 0);
            IpCategory ipCategory = this.getResourceService().ipCategoryRoot();
            this.checkCategory(ipCategory);
            this.treeModel.setData(ipCategory);
            this.treeModel.setSelectedRow(0);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private boolean checkCategory(IpCategory ipCategory) {
        List childrens;
        boolean fl = this.ipResourceCategoryIds.contains(ipCategory.getId());
        if (!fl && (childrens = ipCategory.getChildren()) != null) {
            ArrayList list = new ArrayList(childrens);
            for (IpCategory checkCategory : childrens) {
                if (this.checkCategory(checkCategory)) {
                    fl = true;
                    continue;
                }
                list.remove(checkCategory);
            }
            ipCategory.setChildren(list);
        }
        return fl;
    }

    public boolean doApply() throws Exception {
        if (this.date.getDateCalendar() == null) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430");
            return false;
        }
        if (this.result.getSelectedIndex() < 0) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0430\u0434\u0440\u0435\u0441");
            return false;
        }
        this.paramRowData.value = "";
        IpResourceInstance ipResourceInstance = (IpResourceInstance)this.result.getSelectedValue();
        InetServType inetServType = (InetServType)this.inetServForm.serviceType.getSelectedItem();
        if (inetServType != null) {
            short length = 0;
            IpResource ipResource = (IpResource)this.ipResourceList.getSelectedValue();
            if (ipResource != null) {
                length = ipResource.getPrefixLength();
            }
            if ("IPv6FramedPrefix".equals(this.paramRowData.key) || "IPv6DelegatedPrefix".equals(this.paramRowData.key)) {
                IpNet net = (IpNet)ipResourceInstance;
                this.paramRowData.value = IpAddress.toString((byte[])net.getSubnet());
                this.paramRowData.length = length;
                this.paramRowData.resourceId = ipResourceInstance.getIpResourceId();
            } else if ("IPv4FramedAddress".equals(this.paramRowData.key) || "IPv6FramedAddress".equals(this.paramRowData.key)) {
                IpRange net = (IpRange)ipResourceInstance;
                this.paramRowData.value = IpAddress.toString((byte[])net.getAddressFrom());
                this.paramRowData.length = length;
                this.paramRowData.resourceId = ipResourceInstance.getIpResourceId();
            } else if (inetServType.getAddressType() == InetAddressType.NET) {
                IpNet net = (IpNet)ipResourceInstance;
                if ("IPv4Net".equals(this.paramRowData.key)) {
                    this.paramRowData.value = IpAddress.toString((byte[])net.getSubnet()) + "/" + String.valueOf(net.getMask());
                } else if ("IPv4Range".equals(this.paramRowData.key)) {
                    this.paramRowData.value = IpAddress.toString((byte[])net.getSubnet()) + " - " + IpAddress.toString((byte[])net.getMaxIp());
                }
            } else if (ipResourceInstance instanceof IpNet) {
                IpNet net = (IpNet)ipResourceInstance;
                this.paramRowData.value = IpAddress.toString((byte[])net.getSubnet()) + " - " + IpAddress.toString((byte[])net.getMaxIp());
            } else if (ipResourceInstance instanceof IpRange) {
                IpRange range = (IpRange)ipResourceInstance;
                if ("address".equals(this.paramRowData.key)) {
                    this.paramRowData.value = IpAddress.toString((byte[])range.getAddressFrom());
                } else if ("IPv4Range".equals(this.paramRowData.key)) {
                    this.paramRowData.value = IpAddress.toString((byte[])range.getAddressFrom()) + " - " + IpAddress.toString((byte[])range.getAddressTo());
                }
            }
        }
        return true;
    }

    public void setData() {
        block10: {
            String date = this.date.getDateString();
            if (Utils.isBlankString((String)date)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
                return;
            }
            this.result.setData(new ArrayList());
            Set<Integer> resourceIds = null;
            IpResource ipResource = (IpResource)this.ipResourceList.getSelectedValue();
            if (ipResource == null || ipResource.getId() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441");
                return;
            }
            resourceIds = Collections.singleton(ipResource.getId());
            if ("range".equals(this.rangeCb.getSelectedId()) || "address".equals(this.rangeCb.getSelectedId())) {
                this.range = (int)this.maskRange.getValue();
                try {
                    List listRange = this.getResourceService().freeIpResourceRangeList(this.ipResourceCategoryIds, resourceIds, TimeUtils.convertCalendarToDate((Calendar)this.date.getDateCalendar()), TimeUtils.convertCalendarToDate((Calendar)this.date.getDateCalendar()), (int)this.maskRange.getValue(), (int)this.maxField.getValue(), this.filter.getText());
                    if ("address".equals(this.rangeCb.getSelectedId())) {
                        this.result.setData(listRange.stream().map(p -> new IpResourceAddress(p.getIpResourceId(), p.getAddressFrom())).collect(Collectors.toList()));
                        break block10;
                    }
                    this.result.setData(listRange.stream().map(p -> p).collect(Collectors.toList()));
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            } else if ("mask".equals(this.rangeCb.getSelectedId())) {
                this.mask = (int)this.maskRange.getValue();
                try {
                    this.result.setData(this.getResourceService().freeIpResourceNetList(this.ipResourceCategoryIds, resourceIds, this.date.getDateCalendar().getTime(), this.date.getDateCalendar().getTime(), (int)this.maskRange.getValue(), (int)this.maxField.getValue(), this.filter.getText()).stream().map(p -> p).collect(Collectors.toList()));
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
        }
        ClientSetup.getInstance().getUserConfig().set("inet.resource.ip.free.max", String.valueOf(this.maxField.getValue()));
    }

    private JPanel getFilterPanel() {
        this.buildRangeCmb();
        this.maxField.setValue((long)ClientSetup.getInstance().getUserConfig().getInt("inet.resource.ip.free.max", 100));
        this.filter.setHorizontalAlignment(0);
        this.filter.addActionListener(e -> this.setData());
        this.date.setLocalDate(LocalDate.now());
        JButton doButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        doButton.addActionListener(e -> this.setData());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.rangeCb, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getRangeMaskPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440:"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.filter, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.date, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)this.maxField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)doButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getRangeMaskPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.maskRange, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rangeCb.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                if ("mask".equals((String)((ComboBoxItem)e.getItem()).getObject())) {
                    this.maskRange.setText(String.valueOf(this.mask));
                } else {
                    this.maskRange.setText(String.valueOf(this.range));
                }
            }
        });
        return panel;
    }

    private JPanel getResourcePanel() {
        this.treeTable.addTreeSelectionListener(e -> {
            List<Object> listData = new ArrayList();
            IpCategory ipCategory = (IpCategory)this.treeModel.getSelectedRow();
            if (ipCategory != null) {
                try {
                    listData = this.getResourceService().ipResourceList(Collections.singletonList(ipCategory.getId()));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            Date onDate = this.date.getDate();
            listData = listData.stream().filter(a -> !(a.getDateFrom() != null && !a.getDateFrom().equals(onDate) && !a.getDateFrom().before(onDate) || a.getDateTo() != null && !a.getDateTo().equals(onDate) && !a.getDateTo().after(onDate))).toList();
            this.lockSelection = true;
            this.ipResourceList.clearSelection();
            this.ipResourceList.setData(listData);
            this.lockSelection = false;
            if (!listData.isEmpty()) {
                this.ipResourceList.setSelectedIndex(0);
            }
        });
        this.ipResourceList.addListSelectionListener(e -> {
            if (this.lockSelection) {
                return;
            }
            IpResource ipResource = (IpResource)this.ipResourceList.getSelectedValue();
            if (ipResource != null) {
                if (this.mode == 1) {
                    this.maskRange.setText(ipResource.getPrefixLength() > 0 ? String.valueOf(ipResource.getPrefixLength()) : "32");
                } else if (this.mode == 0) {
                    this.maskRange.setText("1");
                }
                this.setData();
            } else {
                this.result.setData(new ArrayList());
            }
        });
        Dimension dimension = new Dimension(300, 400);
        JScrollPane categoryScrollPane = new JScrollPane((Component)this.treeTable);
        categoryScrollPane.setMinimumSize(dimension);
        categoryScrollPane.setPreferredSize(dimension);
        JScrollPane ipResourceScrollPane = new JScrollPane((Component)this.ipResourceList);
        ipResourceScrollPane.setMinimumSize(dimension);
        ipResourceScrollPane.setPreferredSize(dimension);
        JScrollPane resultScrollPane = new JScrollPane((Component)this.result);
        resultScrollPane.setMinimumSize(dimension);
        resultScrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)categoryScrollPane, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)ipResourceScrollPane, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)resultScrollPane, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private void buildRangeCmb() {
        this.rangeCb.removeAllItems();
        switch (this.mode) {
            case 2: {
                this.maskRange.setText(String.valueOf(this.range));
                this.rangeCb.addItem((Object)new ComboBoxItem((Object)"address", "\u0410\u0434\u0440\u0435\u0441"));
                this.rangeCb.addItem((Object)new ComboBoxItem((Object)"mask", "\u041f\u043e\u0434\u0441\u0435\u0442\u044c"));
                this.rangeCb.addItem((Object)new ComboBoxItem((Object)"range", "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d"));
                break;
            }
            case 3: {
                this.maskRange.setText(String.valueOf(this.range));
                this.rangeCb.addItem((Object)new ComboBoxItem((Object)"range", "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d"));
                break;
            }
            case 0: {
                this.maskRange.setText("1");
                this.rangeCb.addItem((Object)new ComboBoxItem((Object)"address", "\u0410\u0434\u0440\u0435\u0441"));
                break;
            }
            case 1: {
                this.maskRange.setText(String.valueOf(this.mask));
                this.rangeCb.addItem((Object)new ComboBoxItem((Object)"mask", "\u041f\u043e\u0434\u0441\u0435\u0442\u044c"));
            }
        }
    }

    private InetServService getInetServService() {
        if (this.inetServService == null) {
            this.inetServService = (InetServService)this.context.getPort(InetServService.class);
        }
        return this.inetServService;
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = (ResourceService)this.context.getPort(ResourceService.class);
        }
        return this.resourceService;
    }

    public void setDate(Calendar date) {
        this.date.setLocalDate(TimeUtils.convertDateToLocalDate((Date)(date != null ? date.getTime() : null)));
    }

    public Calendar getDate() {
        return this.date.getDateCalendar();
    }

    class IpCategoryTreeModel
    extends BGTreeTableModel<IpCategory> {
        public IpCategoryTreeModel() {
            super(IpCategoryTreeModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", IpCategory.class, -1, 300, -1, "title", false);
            this.addColumnId();
        }
    }
}

