/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.tariff;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class TrafficMaxTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"fugue/chart");
    private JPanel propsPanel;
    private JLabel view = new JLabel();
    private BGComboBox<IdTitle> trafficType1Combo;
    private BGComboBox<IdTitle> trafficType2Combo;
    private BGIntTextField labelField;
    private Directory trafficTypeDir;
    private String trafficType1Title;
    private String trafficType2Title;
    private String mode;
    private String labelId;
    private BGComboBox<ComboBoxItem> modeCombo = null;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.view.setIcon(icon);
        this.trafficTypeDir = this.getDirManager().getDirectory("trafficType");
    }

    private void createPropsPanel() throws Exception {
        this.propsPanel = new JPanel(new GridBagLayout());
        this.trafficType1Combo = new BGComboBox();
        this.trafficType2Combo = new BGComboBox();
        this.modeCombo = new BGComboBox();
        this.buildDirectoryCombo(this.trafficTypeDir, (JComboBox)this.trafficType1Combo);
        this.buildDirectoryCombo(this.trafficTypeDir, (JComboBox)this.trafficType2Combo);
        this.propsPanel.add((Component)this.trafficType1Combo);
        this.propsPanel.add((Component)this.trafficType2Combo);
        this.modeCombo.addItem((Object)new ComboBoxItem((Object)"1", "\u0437\u0430 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434"));
        this.modeCombo.addItem((Object)new ComboBoxItem((Object)"2", "\u0437\u0430 \u043c\u0435\u0441\u044f\u0446"));
        this.modeCombo.addItem((Object)new ComboBoxItem((Object)"3", "\u0437\u0430 \u0434\u0435\u043d\u044c"));
        this.modeCombo.addItem((Object)new ComboBoxItem((Object)"4", "\u0437\u0430 \u0447\u0430\u0441"));
        this.propsPanel.add((Component)new JLabel(this.getLabelTitle()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.propsPanel.add((Component)this.trafficType1Combo, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.propsPanel.add((Component)this.trafficType2Combo, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.propsPanel.add((Component)this.modeCombo, new GridBagConstraints(1, 1, 1, 2, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
        this.labelField = new BGIntTextField();
        this.propsPanel.add((Component)new JLabel("\u041c\u0435\u0442\u043a\u0430:"), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.propsPanel.add((Component)this.labelField, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public Component getView() {
        return this.view;
    }

    public void setData(String data) {
        super.setData(data);
        this.updateView();
    }

    private void updateView() {
        try {
            StringBuffer str = new StringBuffer();
            this.extractData();
            if (Utils.notBlankString((String)this.trafficType1Title)) {
                str.append(this.getLabelTitle());
                str.append("[").append(this.trafficType1Title).append(", ").append(this.trafficType2Title).append("]");
                if ("1".equals(this.mode)) {
                    str.append(" \u0437\u0430 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434");
                } else if ("2".equals(this.mode)) {
                    str.append(" \u0437\u0430 \u043c\u0435\u0441\u044f\u0446");
                } else if ("3".equals(this.mode)) {
                    str.append(" \u0437\u0430 \u0434\u0435\u043d\u044c");
                } else if ("4".equals(this.mode)) {
                    str.append(" \u0437\u0430 \u0447\u0430\u0441");
                }
            }
            long treeNodeId = 0xFFFFFFFF00000000L & (long)this.tree.getTreeId() << 32 | 0xFFFFFFFFL & (long)this.getId();
            str.append(" [").append(treeNodeId).append("]");
            this.view.setText(str.toString());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected void loadData() throws Exception {
        String trafficTypeId2;
        Map data;
        String trafficTypeId1;
        if (this.propsPanel == null) {
            this.createPropsPanel();
        }
        if ((trafficTypeId1 = (String)(data = this.getDataInHash()).get("trafficTypeId1")) == null) {
            trafficTypeId1 = "0";
        }
        if ((trafficTypeId2 = (String)data.get("trafficTypeId2")) == null) {
            trafficTypeId2 = "0";
        }
        this.setDirectoryItemSelection((JComboBox)this.trafficType1Combo, Utils.parseInt((String)trafficTypeId1, (int)0));
        this.setDirectoryItemSelection((JComboBox)this.trafficType2Combo, Utils.parseInt((String)trafficTypeId2, (int)0));
        this.labelField.setText(this.labelId);
    }

    protected void serializeData() {
        ComboBoxItem ci;
        HashMap<String, String> data = new HashMap<String, String>();
        IdTitle di = (IdTitle)this.trafficType1Combo.getSelectedItem();
        if (di != null) {
            data.put("trafficTypeId1", String.valueOf(di.getId()));
        }
        if ((di = (IdTitle)this.trafficType2Combo.getSelectedItem()) != null) {
            data.put("trafficTypeId2", String.valueOf(di.getId()));
        }
        if ((ci = (ComboBoxItem)this.modeCombo.getSelectedItem()) != null) {
            data.put("mode", (String)ci.getObject());
        }
        data.put("labelId", this.labelField.getText());
        this.setDataInHash(data);
        this.updateView();
    }

    public void extractData() throws Exception {
        String trafficTypeId2;
        Map data = this.getDataInHash();
        this.mode = (String)data.get("mode");
        String trafficTypeId1 = (String)data.get("trafficTypeId1");
        if (trafficTypeId1 == null) {
            trafficTypeId1 = "0";
        }
        if ((trafficTypeId2 = (String)data.get("trafficTypeId2")) == null) {
            trafficTypeId2 = "0";
        }
        if (this.trafficTypeDir != null) {
            this.trafficType1Title = this.trafficTypeDir.getValue(Utils.parseInt((String)trafficTypeId1, (int)0));
            this.trafficType2Title = this.trafficTypeDir.getValue(Utils.parseInt((String)trafficTypeId2, (int)0));
        }
        this.labelId = Utils.maskNull((String)((String)data.get("labelId")));
    }

    protected JPanel getEditorPanel() throws Exception {
        if (this.propsPanel == null) {
            this.createPropsPanel();
        }
        return this.propsPanel;
    }

    protected String getLabelTitle() {
        return "\u041f\u0440\u0435\u0432\u0430\u043b\u0438\u0440\u0443\u044e\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a: ";
    }
}

