/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLogger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.event.RequestLogGetEvent;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.DhcpDataLogReader;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.hourly.DhcpHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.datalog.RadiusDataLogReader;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLog;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.concurrent.ConcurrentUtils;

public class RequestLogEventProcessor
implements EventListener<RequestLogGetEvent> {
    public static final String KEY_RADIUS_SECRET = "radius.secret";
    private static final Logger logger = LogManager.getLogger();
    private final DefaultServerSetup setup;
    private final int moduleId;

    public RequestLogEventProcessor(DefaultServerSetup setup) throws BGException {
        this.setup = setup;
        this.moduleId = SetupParam.getModuleId((ParameterMap)setup);
        EventProcessor.getInstance().addListener((EventListener)this, RequestLogGetEvent.class, this.moduleId, "applicationId=" + SetupParam.getApplicationId((ParameterMap)setup));
    }

    public void notify(RequestLogGetEvent requestLogGetEvent, EventListenerContext eventListenerContext) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("requestLogGetEvent.getModuleId() = " + requestLogGetEvent.getModuleId());
            logger.debug("requestLogGetEvent.getApplicationId() = " + requestLogGetEvent.getApplicationId());
            logger.debug("requestLogGetEvent.getDeviceId() = " + requestLogGetEvent.getDeviceId());
            logger.debug("requestLogGetEvent.getLogEntryList():");
            for (ConnectionLogEntry connectionLogEntry : requestLogGetEvent.getLogEntryList()) {
                logger.debug("\tRequestDataLogId:" + connectionLogEntry.getRequestDataLogId() + "; RequestChunkId:" + connectionLogEntry.getRequestChunkId() + "; RequestPosition:" + connectionLogEntry.getRequestPosition());
            }
        }
        List list = requestLogGetEvent.getLogEntryList();
        HashSet<Long> radiusFlush = new HashSet<Long>();
        HashSet<Long> dhcpFlush = new HashSet<Long>();
        requestLogGetEvent.setLogEntryResultList(new ArrayList());
        HourlyDataLogger radiusDataLogger = null;
        try {
            radiusDataLogger = (HourlyDataLogger)DefaultServerSetup.getEnvironment().lookup("radiusDataLogger");
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        HourlyDataLogger dhcpDataLogger = null;
        try {
            dhcpDataLogger = (HourlyDataLogger)DefaultServerSetup.getEnvironment().lookup("dhcpDataLogger");
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        block15: for (ConnectionLogEntry connectionLogEntry : list) {
            switch (connectionLogEntry.getLogType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    Long hourPart = radiusDataLogger.getHourPart(connectionLogEntry.getTime().getTime());
                    if (!radiusFlush.add(hourPart)) continue block15;
                    futures.add(radiusDataLogger.flushHourPart(hourPart));
                    break;
                }
                case 5: {
                    Long hourPart = dhcpDataLogger.getHourPart(connectionLogEntry.getTime().getTime());
                    if (!dhcpFlush.add(hourPart)) break;
                    futures.add(dhcpDataLogger.flushHourPart(hourPart));
                }
            }
        }
        try {
            ConcurrentUtils.awaitFutures(futures, (long)4L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        InetDeviceMap inetDeviceMap = InetDeviceMap.getInstance(this.moduleId);
        InetDeviceMap.InetDeviceMapItem inetDeviceItem = inetDeviceMap != null ? inetDeviceMap.get(requestLogGetEvent.getDeviceId()) : null;
        byte[] secret = null;
        if (inetDeviceItem != null) {
            secret = Utils.maskNull((String)inetDeviceItem.getConfig().get(KEY_RADIUS_SECRET, inetDeviceItem.getDevice().getSecret())).getBytes(StandardCharsets.UTF_8);
            if (logger.isDebugEnabled()) {
                logger.debug("secret: " + String.valueOf(secret));
            }
        }
        for (ConnectionLogEntry connectionLogEntry : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("connectionLogEntry.getTime() = " + String.valueOf(connectionLogEntry.getTime()));
                logger.debug("connectionLogEntry.getLogType() = " + connectionLogEntry.getLogType());
            }
            switch (connectionLogEntry.getLogType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    RadiusHourlyDataLog dataLog = new RadiusHourlyDataLog(this.setup, requestLogGetEvent.getDeviceId(), TimeUtils.convertDateToCalendar((Date)connectionLogEntry.getTime()));
                    this.addToLog(requestLogGetEvent, dataLog, connectionLogEntry, secret);
                    dataLog.close();
                    break;
                }
                case 5: {
                    RadiusHourlyDataLog dataLog = new DhcpHourlyDataLog(this.setup, requestLogGetEvent.getDeviceId(), TimeUtils.convertDateToCalendar((Date)connectionLogEntry.getTime()));
                    this.addToLog(requestLogGetEvent, (DhcpHourlyDataLog)dataLog, connectionLogEntry);
                    dataLog.close();
                }
            }
        }
    }

    private void addToLog(RequestLogGetEvent requestLogGetEvent, int id, long[] millisRef, Object packet) {
        if (packet != null) {
            String str = packet.toString();
            StringBuilder buf = new StringBuilder(str.length() + 100);
            str = XMLUtils.prepareString((StringBuilder)buf, (String)str);
            if (logger.isDebugEnabled()) {
                logger.debug("Add to result " + id + " " + millisRef[0] + ":\n" + str);
            }
            requestLogGetEvent.getLogEntryResultList().add(new RequestLogGetEvent.LogEntryResult(id, millisRef[0], str));
        } else {
            logger.warn("Packet not found!");
        }
    }

    private void addToLog(RequestLogGetEvent requestLogGetEvent, DhcpHourlyDataLog dataLog, ConnectionLogEntry connectionLogEntry) {
        DhcpDataLogReader reader;
        if (logger.isDebugEnabled()) {
            logger.debug("addToLog(...) searching " + connectionLogEntry.getRequestDataLogId() + ":" + connectionLogEntry.getRequestChunkId() + ":" + connectionLogEntry.getRequestPosition());
        }
        if ((reader = dataLog.find(null, connectionLogEntry.getRequestDataLogId(), connectionLogEntry.getRequestChunkId(), connectionLogEntry.getRequestPosition())) != null) {
            long[] millisRef = new long[1];
            this.addToLog(requestLogGetEvent, connectionLogEntry.getId(), millisRef, reader.read(millisRef));
            reader = dataLog.find(reader, connectionLogEntry.getResponseDataLogId(), connectionLogEntry.getResponseChunkId(), connectionLogEntry.getResponsePosition());
            if (reader != null) {
                this.addToLog(requestLogGetEvent, connectionLogEntry.getId(), millisRef, reader.read(millisRef));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("DhcpDataLogReader not found");
        }
    }

    private void addToLog(RequestLogGetEvent requestLogGetEvent, RadiusHourlyDataLog dataLog, ConnectionLogEntry connectionLogEntry, byte[] secret) {
        RadiusDataLogReader reader;
        if (logger.isDebugEnabled()) {
            logger.debug("addToLog(...) searching " + connectionLogEntry.getRequestDataLogId() + ":" + connectionLogEntry.getRequestChunkId() + ":" + connectionLogEntry.getRequestPosition());
        }
        if ((reader = dataLog.find(null, connectionLogEntry.getRequestDataLogId(), connectionLogEntry.getRequestChunkId(), connectionLogEntry.getRequestPosition())) != null) {
            long[] millisRef = new long[1];
            RadiusPacket packet = reader.read(millisRef);
            if (connectionLogEntry.getLogType() == 1 && secret != null) {
                try {
                    RadiusUtils.decryptPassword((RadiusPacket)packet, (byte[])secret);
                }
                catch (Exception ex) {
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
            }
            this.addToLog(requestLogGetEvent, connectionLogEntry.getId(), millisRef, packet);
            reader = dataLog.find(reader, connectionLogEntry.getResponseDataLogId(), connectionLogEntry.getResponseChunkId(), connectionLogEntry.getResponsePosition());
            if (reader != null) {
                packet = reader.read(millisRef);
                this.addToLog(requestLogGetEvent, connectionLogEntry.getId(), millisRef, packet);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("RadiusDataLogReader not found");
        }
    }
}

