/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Channel;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ChannelManager {
    private Connection con;
    private int mid;

    public ChannelManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public void updateChannel(Channel channel) throws BGException {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (channel.getId() <= 0) {
                query = "INSERT INTO channel_" + this.mid + " (title) VALUES (?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE channel_" + this.mid + " SET title=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(2, channel.getId());
            }
            ps.setString(1, channel.getTitle());
            ps.executeUpdate();
            if (channel.getId() <= 0) {
                channel.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<Channel> getChannelList() throws BGException {
        ArrayList<Channel> result = new ArrayList<Channel>(100);
        try {
            String query = "SELECT * FROM channel_" + this.mid + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Channel channel = new Channel();
                this.loadChannelFromRS(rs, channel);
                result.add(channel);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public Map<Integer, Channel> getChannelMap() throws BGException {
        HashMap<Integer, Channel> result = new HashMap<Integer, Channel>();
        try {
            String query = "SELECT * FROM channel_" + this.mid + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Channel channel = new Channel();
                this.loadChannelFromRS(rs, channel);
                result.put(channel.getId(), channel);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public Channel getChannelById(int id) throws BGException {
        Channel result = null;
        try {
            String query = "SELECT * FROM channel_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new Channel();
                this.loadChannelFromRS(rs, result);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void deleteChannel(int id) throws BGException {
        try {
            String query = "DELETE FROM channel_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void loadChannelFromRS(ResultSet rs, Channel channel) throws SQLException {
        channel.setId(rs.getInt("id"));
        channel.setTitle(rs.getString("title"));
    }
}

