/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bvcom.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.bvcom.common.bean.Transaction;
import ru.bitel.bgbilling.modules.bvcom.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.bvcom.common.service.BVComService;
import ru.bitel.bgbilling.modules.bvcom.server.bean.BVParams;
import ru.bitel.bgbilling.modules.bvcom.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.bvcom.common.service.BVComService")
public class BVComServiceImpl
extends AbstractService
implements BVComService {
    private BVParams params;

    @PostConstruct
    public void init() {
        this.params = new BVParams(Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)));
    }

    private TransactionManager getTransactionManager() {
        return new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(int contractId, String contractTitle, String status, PeriodWithTime period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        this.getTransactionManager().searchTransaction((SearchResult<Transaction>)searchResult, contractId > 0 ? contractId : -1, contractId > 0 ? null : contractTitle, status);
        return searchResult;
    }

    public Transaction getTransaction(int transactionId) throws Exception {
        return this.getTransactionManager().getTransactionById(transactionId);
    }

    public void addTransaction(Transaction transaction) throws Exception {
        this.getTransactionManager().addTransaction(transaction);
    }

    public void updateTransaction(Transaction transaction) throws Exception {
        this.getTransactionManager().update(transaction);
    }

    public void returnMoney(Transaction transaction) throws Exception {
        String[] answerValues;
        String login = this.params.getClient();
        String orderId = transaction.getBvcomOrderId();
        String clientOrderId = this.params.getTransactionFormat().format(transaction.getId());
        String comment = "We need money";
        String control = "";
        MessageDigest hash = MessageDigest.getInstance("SHA-1");
        hash.update(login.getBytes());
        hash.update(clientOrderId.getBytes());
        hash.update(orderId.getBytes());
        hash.update(this.params.getMerchantControl().getBytes());
        control = Utils.bytesToHexString((byte[])hash.digest()).toLowerCase();
        URL url = new URL(this.params.getServerUrl() + "return/" + this.params.getEndPointId());
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setDoOutput(true);
        StringBuilder urlString = new StringBuilder();
        urlString.append("login=" + login);
        urlString.append("&orderid=" + orderId);
        urlString.append("&client_orderid=" + clientOrderId);
        urlString.append("&control=" + control);
        urlString.append("&comment=" + comment);
        this.getLogger().info("Query to BVCom: " + url.toString() + "?" + String.valueOf(urlString));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
        bw.write(urlString.toString().toCharArray());
        bw.close();
        connection.connect();
        InputStream is = connection.getInputStream();
        char[] bvcom_answer = new char[is.available()];
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        br.read(bvcom_answer);
        this.getLogger().info("BVCom answer: " + new String(bvcom_answer));
        br.close();
        HashMap<String, String> paramVal = new HashMap<String, String>();
        for (String s : answerValues = new String(bvcom_answer).trim().split("&")) {
            String[] tmp = s.trim().split("=");
            paramVal.put(tmp[0], tmp[1]);
        }
        if (paramVal.containsKey("type") && ((String)paramVal.get("type")).equals("async-response")) {
            transaction.setStatus(TransactionStatus.MONEY_RETURN_PROCESSING.getCode());
            this.updateTransaction(transaction);
        }
    }

    public List<Transaction> getReturnTransactionList() throws Exception {
        return this.getTransactionManager().getReturnMoneyTransactionList();
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> outerParamsHolder) throws BGException {
        if (mode != null) {
            mode.value = "post";
        }
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
        }
        this.tryCall(() -> {
            try (BalanceUtils bu = new BalanceUtils(this.getConnection());){
                if (this.params.getProtocolVersion() == 2) {
                    this.beginTransactionV2(contractId, amount, url, mode, outerParamsHolder);
                } else {
                    BigDecimal sum = amount;
                    Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setSum(sum)).build();
                    this.addTransaction(transaction);
                    String client = this.params.getClient();
                    String currency = String.valueOf(BVParams.getOldProtocolCurrency());
                    String number = this.params.getTransactionFormat().format(transaction.getId());
                    MessageDigest md = MessageDigest.getInstance("md5");
                    md.update(client.getBytes("ISO8859-1"));
                    md.update(new String("|").getBytes("ISO8859-1"));
                    md.update(number.getBytes("ISO8859-1"));
                    md.update(new String("|").getBytes("ISO8859-1"));
                    md.update(Utils.formatCost((BigDecimal)sum).getBytes("ISO8859-1"));
                    md.update(new String("|").getBytes("ISO8859-1"));
                    md.update(currency.getBytes("ISO8859-1"));
                    md.update(new String("|").getBytes("ISO8859-1"));
                    md.update(this.params.getKey().getBytes("ISO8859-1"));
                    String sign = Utils.bytesToHexString((byte[])md.digest()).toLowerCase();
                    Map outerParams = outerParamsHolder != null && outerParamsHolder.value != null ? ((MapHolder)outerParamsHolder.value).getMap() : null;
                    String resultUrl = outerParams != null ? (String)outerParams.get("resultUrl") : null;
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    dataMap.put("client", client);
                    dataMap.put("number", number);
                    dataMap.put("amount", Utils.formatCost((BigDecimal)sum));
                    dataMap.put("currency", currency);
                    dataMap.put("description", this.params.getComment());
                    dataMap.put("sign", sign);
                    if (Utils.notBlankString((String)resultUrl)) {
                        dataMap.put("url", resultUrl);
                    } else {
                        dataMap.put("url", this.params.getResultUrl());
                    }
                    if (outerParamsHolder != null) {
                        outerParamsHolder.value = new MapHolder(dataMap);
                    }
                    url.value = "http://payment.bvcom.ru/";
                }
            }
        });
    }

    private void beginTransactionV2(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> outerParamsHolder) throws Exception {
        String[] answerValues;
        if (mode != null) {
            mode.value = "redirect";
        }
        if (outerParamsHolder == null) {
            throw new BGIllegalArgumentException("params");
        }
        if (outerParamsHolder.value == null) {
            throw new BGIllegalArgumentException("params.value");
        }
        if (((MapHolder)outerParamsHolder.value).getMap().get("ipAddress") == null) {
            throw new BGIllegalArgumentException("params.value.ipAddress");
        }
        BigDecimal sum = amount;
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setSum(sum)).build();
        this.addTransaction(transaction);
        String clientOrderId = this.params.getTransactionFormat().format(transaction.getId());
        HashMap<String, String> paramVal = new HashMap<String, String>();
        int endpointid = this.params.getEndPointId();
        String merchantControl = this.params.getMerchantControl();
        String callbackUrl = this.params.getCallbackUrl();
        String ipAddress = (String)((MapHolder)outerParamsHolder.value).getMap().get("ipAddress");
        String resultUrl = (String)((MapHolder)outerParamsHolder.value).getMap().get("resultUrl");
        if (Utils.isBlankString((String)resultUrl)) {
            resultUrl = this.params.getResultUrl();
        }
        String currency = this.params.getCurrency();
        String email = "email@example.org";
        String country = "RU";
        String city = "Castle_Rock";
        String address1 = "Not_specified";
        String zipCode = "000000";
        String description = this.params.getComment();
        String control = this.getControlHash(String.valueOf(endpointid), clientOrderId, Utils.formatCost((BigDecimal)amount), email, merchantControl);
        URL bvcomUrl = new URL(this.params.getServerUrl() + "sale-form/" + endpointid);
        HttpsURLConnection connection = (HttpsURLConnection)bvcomUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        connection.setDoOutput(true);
        StringBuilder urlString = new StringBuilder();
        urlString.append("client_orderid=" + clientOrderId);
        urlString.append("&amount=" + String.valueOf(amount));
        urlString.append("&currency=" + currency);
        urlString.append("&order_desc=" + URLEncoder.encode(description, "UTF-8"));
        urlString.append("&redirect_url=" + resultUrl);
        urlString.append("&ipaddress=" + ipAddress);
        urlString.append("&server_callback_url=" + callbackUrl);
        urlString.append("&control=" + control);
        urlString.append("&country=" + country);
        urlString.append("&city=" + city);
        urlString.append("&zip_code=" + zipCode);
        urlString.append("&address1=" + address1);
        urlString.append("&email=" + email);
        this.getLogger().info("Query to BVCom: " + url.toString() + "?" + String.valueOf(urlString));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
        bw.write(urlString.toString().toCharArray());
        bw.close();
        connection.connect();
        InputStream is = connection.getInputStream();
        char[] bvcom_answer = new char[is.available()];
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        br.read(bvcom_answer);
        this.getLogger().info("BVCom answer: " + new String(bvcom_answer));
        br.close();
        for (String s : answerValues = new String(bvcom_answer).trim().split("&")) {
            String[] tmp = s.trim().split("=");
            paramVal.put(tmp[0], tmp[1]);
        }
        if (paramVal.containsKey("paynet-order-id")) {
            String paynetOrderId = (String)paramVal.get("paynet-order-id");
            transaction.setBvcomOrderId(paynetOrderId);
            this.updateTransaction(transaction);
            String redirect = (String)paramVal.get("redirect-url");
            url.value = URLDecoder.decode(redirect, "UTF-8");
            outerParamsHolder.value = null;
        }
    }

    private String getControlHash(String endpointid, String clientOrderId, String amount, String email, String merchantControl) throws Exception {
        String result = null;
        Double tmpAmount = Double.valueOf(amount) * 100.0;
        int newAmount = tmpAmount.intValue();
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(endpointid.getBytes());
        md.update(clientOrderId.getBytes());
        md.update(String.valueOf(newAmount).getBytes());
        md.update(email.getBytes());
        md.update(merchantControl.getBytes());
        result = Utils.bytesToHexString((byte[])md.digest()).toLowerCase();
        return result;
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException {
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        return null;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
    }
}

